/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.CDORevisionManager;
import org.eclipse.emf.cdo.analyzer.CDOFetchRuleManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDOReferenceProxy;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionResolverImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.LoadChunkRequest;
import org.eclipse.emf.internal.cdo.protocol.LoadRevisionByTimeRequest;
import org.eclipse.emf.internal.cdo.protocol.LoadRevisionByVersionRequest;
import org.eclipse.emf.internal.cdo.protocol.LoadRevisionRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.om.trace.PerfTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionManagerImpl
extends CDORevisionResolverImpl
implements CDORevisionManager {
    private static final PerfTracer LOADING = new PerfTracer(OM.PERF_REVISION_LOADING, CDORevisionManagerImpl.class);
    private CDOSessionImpl session;
    private CDOFetchRuleManager ruleManager = CDOFetchRuleManager.NOOP;

    public CDORevisionManagerImpl(CDOSessionImpl session) {
        this.session = session;
    }

    @Override
    public CDOSessionImpl getSession() {
        return this.session;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return this.session;
    }

    public CDOID resolveReferenceProxy(CDOReferenceProxy referenceProxy) {
        InternalCDORevision revision = (InternalCDORevision)referenceProxy.getRevision();
        CDOFeature feature = referenceProxy.getFeature();
        int accessIndex = referenceProxy.getIndex();
        int chunkSize = this.session.getReferenceChunkSize();
        if (chunkSize == -1) {
            chunkSize = Integer.MAX_VALUE;
        }
        MoveableList list = revision.getList(feature);
        int size = list.size();
        int fromIndex = accessIndex;
        int toIndex = accessIndex;
        boolean minReached = false;
        boolean maxReached = false;
        boolean alternation = false;
        int i = 0;
        while (i < chunkSize) {
            if (alternation) {
                if (!maxReached && toIndex < size - 1 && list.get(toIndex + 1) instanceof CDOReferenceProxy) {
                    ++toIndex;
                } else {
                    maxReached = true;
                }
                if (!minReached) {
                    alternation = false;
                }
            } else {
                if (!minReached && fromIndex > 0 && list.get(fromIndex - 1) instanceof CDOReferenceProxy) {
                    --fromIndex;
                } else {
                    minReached = true;
                }
                if (!maxReached) {
                    alternation = true;
                }
            }
            if (minReached && maxReached) break;
            ++i;
        }
        try {
            IFailOverStrategy failOverStrategy = this.session.getFailOverStrategy();
            IChannel channel = this.session.getChannel();
            LoadChunkRequest request = new LoadChunkRequest(channel, revision, feature, accessIndex, fromIndex, toIndex);
            return (CDOID)failOverStrategy.send((RequestWithConfirmation)request);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    public List<Integer> analyzeReferenceRanges(List<Object> list) {
        int size;
        ArrayList<Integer> ranges = new ArrayList<Integer>(0);
        int range = 0;
        int lastIndex = -1;
        for (Object value : list) {
            CDOReferenceProxy proxy;
            if (lastIndex == -1) {
                if (value instanceof CDOReferenceProxy) {
                    if (range != 0) {
                        ranges.add(range);
                        range = 0;
                    }
                    proxy = (CDOReferenceProxy)value;
                    lastIndex = proxy.getIndex();
                    --range;
                    continue;
                }
                ++range;
                continue;
            }
            if (value instanceof CDOReferenceProxy) {
                proxy = (CDOReferenceProxy)value;
                int index = proxy.getIndex();
                if (index == lastIndex + 1) {
                    --range;
                } else {
                    ranges.add(range);
                    range = -1;
                }
                lastIndex = index;
                continue;
            }
            if (range != 0) {
                ranges.add(range);
                range = 1;
            }
            lastIndex = -1;
        }
        if (range != 0) {
            ranges.add(range);
        }
        if ((size = ranges.size()) == 0 || size == 1 && (Integer)ranges.get(0) > 0) {
            return null;
        }
        return ranges;
    }

    protected InternalCDORevision loadRevision(CDOID id, int referenceChunk) {
        return this.send(new LoadRevisionRequest(this.session.getChannel(), (Collection<CDOID>)Collections.singleton(id), referenceChunk)).get(0);
    }

    protected InternalCDORevision loadRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        return this.send(new LoadRevisionByTimeRequest(this.session.getChannel(), (Collection<CDOID>)Collections.singleton(id), referenceChunk, timeStamp)).get(0);
    }

    protected InternalCDORevision loadRevisionByVersion(CDOID id, int referenceChunk, int version) {
        return this.send(new LoadRevisionByVersionRequest(this.session.getChannel(), id, referenceChunk, version)).get(0);
    }

    protected List<InternalCDORevision> loadRevisions(Collection<CDOID> ids, int referenceChunk) {
        return this.send(new LoadRevisionRequest(this.session.getChannel(), ids, referenceChunk));
    }

    protected List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        return this.send(new LoadRevisionByTimeRequest(this.session.getChannel(), ids, referenceChunk, timeStamp));
    }

    private List<InternalCDORevision> send(LoadRevisionRequest request) {
        try {
            LOADING.start((Object)request);
            IFailOverStrategy failOverStrategy = this.session.getFailOverStrategy();
            List list = (List)failOverStrategy.send((RequestWithConfirmation)request);
            return list;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
        finally {
            LOADING.stop((Object)request);
        }
    }

    public CDOFetchRuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(CDOFetchRuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }
}

