/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.net4j.util.StringUtil;

public class View
implements IView {
    private Session session;
    private int viewID;
    private IRepository repository;
    private Set<CDOID> changeSubscriptionIDs = new HashSet<CDOID>();

    public View(Session session, int viewID) {
        this.session = session;
        this.viewID = viewID;
        this.repository = session.getSessionManager().getRepository();
    }

    public Session getSession() {
        return this.session;
    }

    public int getViewID() {
        return this.viewID;
    }

    public CDOCommonView.Type getViewType() {
        return CDOCommonView.Type.READONLY;
    }

    public IRepository getRepository() {
        this.checkOpen();
        return this.repository;
    }

    public CDOID getResourceID(String path) {
        this.checkOpen();
        long timeStamp = this.getTimeStamp();
        CDOID resourceID = null;
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (StringUtil.isEmpty((String)token) || (resourceID = this.getResourceID(resourceID, token, timeStamp)) != null) continue;
            return null;
        }
        return resourceID;
    }

    private CDOID getResourceID(CDOID folderID, String name, long timeStamp) {
        CDOID id = this.repository.getRevisionManager().getResourceID(folderID, name, timeStamp);
        if (id == null) {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            id = accessor.readResourceID(folderID, name, timeStamp);
        }
        return id;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public synchronized void subscribe(CDOID id) {
        this.checkOpen();
        this.changeSubscriptionIDs.add(id);
    }

    public synchronized void unsubscribe(CDOID id) {
        this.checkOpen();
        this.changeSubscriptionIDs.remove(id);
    }

    public synchronized boolean hasSubscription(CDOID id) {
        this.checkOpen();
        return this.changeSubscriptionIDs.contains(id);
    }

    public synchronized void clearChangeSubscription() {
        this.checkOpen();
        this.changeSubscriptionIDs.clear();
    }

    public String toString() {
        return MessageFormat.format("View[{0}]", this.viewID);
    }

    public void close() {
        if (!this.isClosed()) {
            this.session.viewClosed(this);
        }
    }

    public void doClose() {
        this.clearChangeSubscription();
        this.session = null;
        this.repository = null;
        this.changeSubscriptionIDs = null;
    }

    public boolean isClosed() {
        return this.session == null;
    }

    private void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("View closed");
        }
    }
}

