/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDOPropertyHandler {
    private final ContextTracer tracer = new ContextTracer(OM.DEBUG, this.getClass());
    private CDORevisionTuplizer tuplizer;
    private EStructuralFeature feature;
    private boolean virtualProperty = false;

    public CDOPropertyHandler(CDORevisionTuplizer tuplizer, String propertyName) {
        this.tuplizer = tuplizer;
        this.feature = tuplizer.getEClass().getEStructuralFeature(propertyName);
        if (this.getTracer().isEnabled()) {
            this.getTracer().trace("Created " + this.getClass().getName() + " for eClass/feature: " + tuplizer.getEClass().getName() + "." + propertyName);
        }
        if (this.feature == null) {
            if (this.isVirtualPropertyAllowed()) {
                this.virtualProperty = true;
                if (this.getTracer().isEnabled()) {
                    this.getTracer().trace("This is a virtual property");
                }
            } else {
                throw new IllegalStateException("Feature not found: " + propertyName);
            }
        }
    }

    protected ContextTracer getTracer() {
        return this.tracer;
    }

    public CDORevisionTuplizer getTuplizer() {
        return this.tuplizer;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.feature;
    }

    protected boolean isVirtualPropertyAllowed() {
        return false;
    }

    public boolean isVirtualProperty() {
        return this.virtualProperty;
    }
}

