/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.net4j.util.collection.MoveableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveableListWrapper
implements MoveableList<Object> {
    private List<Object> delegate;

    public MoveableListWrapper(List<Object> delegate) {
        this.delegate = delegate;
    }

    public List<Object> getDelegate() {
        return this.delegate;
    }

    public Object move(int targetIndex, int sourceIndex) {
        int size = this.size();
        if (sourceIndex >= size) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex >= size) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        Object object = this.get(sourceIndex);
        if (targetIndex == sourceIndex) {
            return object;
        }
        if (targetIndex < sourceIndex) {
            this.moveUp1(targetIndex, sourceIndex - targetIndex);
        } else {
            this.moveDown1(targetIndex, targetIndex - sourceIndex);
        }
        this.set(targetIndex, object);
        return object;
    }

    private void moveUp1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index + i, this.get(index + i - 1));
            --i;
        }
    }

    private void moveDown1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index - i, this.get(index - i + 1));
            --i;
        }
    }

    public void add(int index, Object element) {
        this.delegate.add(index, element);
    }

    public boolean add(Object e) {
        return this.delegate.add(e);
    }

    public boolean addAll(Collection<? extends Object> c) {
        return this.delegate.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.delegate.addAll(index, c);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    public ListIterator<Object> listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator<Object> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    public Object remove(int index) {
        return this.delegate.remove(index);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    public Object set(int index, Object element) {
        return this.delegate.set(index, element);
    }

    public int size() {
        return this.delegate.size();
    }

    public List<Object> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }
}

