/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.hibernate.Session;

public class HibernateUtil {
    private static final String EXT_POINT = "mappingProviderFactories";
    private static HibernateUtil instance = new HibernateUtil();

    public static HibernateUtil getInstance() {
        return instance;
    }

    public static void setInstance(HibernateUtil instance) {
        HibernateUtil.instance = instance;
    }

    public IHibernateStore createStore(IHibernateMappingProvider mappingProvider) {
        HibernateStore store = new HibernateStore(mappingProvider);
        mappingProvider.setHibernateStore(store);
        return store;
    }

    public Session getHibernateSession() {
        HibernateStoreReader storeReader = (HibernateStoreReader)HibernateThreadContext.getCurrentHibernateStoreAccessor();
        return storeReader.getHibernateSession();
    }

    public Properties getPropertiesFromStore(IStore store) {
        Properties props = new Properties();
        Map storeProps = store.getRepository().getProperties();
        for (String key : storeProps.keySet()) {
            props.setProperty(key, (String)storeProps.get(key));
        }
        return props;
    }

    public String getEntityName(CDORevision cdoRevision) {
        return cdoRevision.getCDOClass().getName();
    }

    public CDOIDHibernate getCDOIDHibernate(CDOID cdoID) {
        CDORevision cdoRevision = this.getCDORevision(cdoID);
        if (cdoRevision.getID() instanceof CDOIDHibernate) {
            return (CDOIDHibernate)cdoRevision.getID();
        }
        Session session = this.getHibernateSession();
        if (!(cdoRevision.getID() instanceof CDOIDHibernate)) {
            session.saveOrUpdate((Object)cdoRevision);
        }
        if (!(cdoRevision.getID() instanceof CDOIDHibernate)) {
            throw new IllegalStateException("CDORevision " + cdoRevision.getCDOClass().getName() + " " + cdoRevision.getID() + " does not have a hibernate cdoid after saving/updating it");
        }
        return (CDOIDHibernate)cdoRevision.getID();
    }

    public InternalCDORevision getCDORevision(Object target) {
        return (InternalCDORevision)target;
    }

    public CDORevision getCDORevision(CDOID id) {
        if (id.isNull()) {
            return null;
        }
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            CDOID newID;
            HibernateCommitContext hcc = HibernateThreadContext.getHibernateCommitContext();
            CDORevision revision = hcc.getDirtyObject(id);
            if (revision != null) {
                return revision;
            }
            revision = hcc.getNewObject(id);
            if (revision != null) {
                return revision;
            }
            if (id instanceof CDOIDTemp && (newID = (CDOID)hcc.getCommitContext().getIDMappings().get(id)) != null) {
                return this.getCDORevision(newID);
            }
        }
        if (!(id instanceof CDOIDHibernate)) {
            throw new IllegalArgumentException("Passed cdoid is not an instance of CDOIDHibernate but a " + id.getClass().getName() + ": " + id);
        }
        CDOIDHibernate cdoIDHibernate = (CDOIDHibernate)id;
        Session session = this.getHibernateSession();
        return (CDORevision)session.get(cdoIDHibernate.getEntityName(), cdoIDHibernate.getId());
    }

    public CDORevision getCDORevisionNullable(CDOID id) {
        if (id.isNull()) {
            return null;
        }
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            CDOID newID;
            HibernateCommitContext hcc = HibernateThreadContext.getHibernateCommitContext();
            CDORevision revision = hcc.getDirtyObject(id);
            if (revision != null) {
                return revision;
            }
            revision = hcc.getNewObject(id);
            if (revision != null) {
                return revision;
            }
            if (id instanceof CDOIDTemp && (newID = (CDOID)hcc.getCommitContext().getIDMappings().get(id)) != null) {
                return this.getCDORevision(newID);
            }
        }
        if (!(id instanceof CDOIDHibernate)) {
            return null;
        }
        CDOIDHibernate cdoIDHibernate = (CDOIDHibernate)id;
        Session session = this.getHibernateSession();
        return (CDORevision)session.get(cdoIDHibernate.getEntityName(), cdoIDHibernate.getId());
    }
}

