/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;

public abstract class TypeMapping
implements ITypeMapping {
    private IMappingStrategy mappingStrategy;
    private EStructuralFeature feature;
    private IDBField field;

    public TypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature) {
        this.mappingStrategy = mappingStrategy;
        this.feature = feature;
    }

    public final void setValueFromRevision(PreparedStatement stmt, int index, InternalCDORevision revision) throws SQLException {
        this.setValue(stmt, index, this.getRevisionValue(revision));
    }

    public final void setValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, this.getSqlType());
        } else {
            this.doSetValue(stmt, index, value);
        }
    }

    public final void createDBField(IDBTable table) {
        this.createDBField(table, this.mappingStrategy.getFieldName(this.feature));
    }

    public final void createDBField(IDBTable table, String fieldName) {
        DBType fieldType = this.getDBType();
        int fieldLength = this.getDBLength(fieldType);
        this.field = table.addField(fieldName, fieldType, fieldLength);
    }

    public final IDBField getField() {
        return this.field;
    }

    public final void readValueToRevision(ResultSet resultSet, int index, InternalCDORevision revision) throws SQLException {
        Object value = this.readValue(resultSet, index);
        revision.setValue(this.getFeature(), value);
    }

    public final Object readValue(ResultSet resultSet, int index) throws SQLException {
        Object value = this.getResultSetValue(resultSet, index);
        if (resultSet.wasNull()) {
            value = null;
        }
        return value;
    }

    public final EStructuralFeature getFeature() {
        return this.feature;
    }

    protected final Object getRevisionValue(InternalCDORevision revision) {
        return revision.getValue(this.getFeature());
    }

    protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        stmt.setObject(index, value, this.getSqlType());
    }

    protected int getSqlType() {
        return this.getDBType().getCode();
    }

    protected DBType getDBType() {
        return this.mappingStrategy.getStore().getMetaDataManager().getDBType(this.feature.getEType());
    }

    protected int getDBLength(DBType type) {
        return type == DBType.VARCHAR ? 32672 : -1;
    }

    protected abstract Object getResultSetValue(ResultSet var1, int var2) throws SQLException;

    public static class TMBigDecimal
    extends TypeMapping {
        public TMBigDecimal(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            String val = resultSet.getString(column);
            if (resultSet.wasNull()) {
                return null;
            }
            return new BigDecimal(val);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((BigDecimal)value).toPlainString());
        }
    }

    public static class TMBigInteger
    extends TypeMapping {
        public TMBigInteger(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            String val = resultSet.getString(column);
            if (resultSet.wasNull()) {
                return null;
            }
            return new BigInteger(val);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((BigInteger)value).toString());
        }
    }

    public static class TMBoolean
    extends TypeMapping {
        public TMBoolean(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getBoolean(column);
        }
    }

    public static class TMByte
    extends TypeMapping {
        public TMByte(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getByte(column);
        }
    }

    public static class TMBytes
    extends TypeMapping {
        public TMBytes(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getBytes(column);
        }
    }

    public static class TMCharacter
    extends TypeMapping {
        public TMCharacter(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            String str = resultSet.getString(column);
            if (resultSet.wasNull()) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    public static class TMDate
    extends TypeMapping {
        public TMDate(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getTimestamp(column);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setTimestamp(index, new Timestamp(((Date)value).getTime()));
        }
    }

    public static class TMDouble
    extends TypeMapping {
        public TMDouble(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getDouble(column);
        }
    }

    public static class TMEnum
    extends TypeMapping {
        public TMEnum(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getInt(column);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            super.doSetValue(stmt, index, value);
        }
    }

    public static class TMFloat
    extends TypeMapping {
        public TMFloat(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return Float.valueOf(resultSet.getFloat(column));
        }
    }

    public static class TMInteger
    extends TypeMapping {
        public TMInteger(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getInt(column);
        }
    }

    public static class TMLong
    extends TypeMapping {
        public TMLong(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getLong(column);
        }
    }

    public static class TMObject
    extends TypeMapping {
        public TMObject(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            long id = resultSet.getLong(column);
            if (resultSet.wasNull()) {
                return null;
            }
            return CDOIDUtil.createLong((long)id);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            super.doSetValue(stmt, index, CDODBUtil.getLong((CDOID)value));
        }
    }

    public static class TMShort
    extends TypeMapping {
        public TMShort(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getShort(column);
        }
    }

    public static class TMString
    extends TypeMapping {
        public TMString(IMappingStrategy strategy, EStructuralFeature feature) {
            super(strategy, feature);
        }

        public Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getString(column);
        }
    }
}

