/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelElement;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IDBStoreWriter;
import org.eclipse.emf.cdo.server.db.IReferenceMapping;
import org.eclipse.emf.cdo.server.internal.db.ClassMapping;
import org.eclipse.emf.cdo.server.internal.db.FeatureMapping;
import org.eclipse.emf.cdo.server.internal.db.FeatureServerInfo;
import org.eclipse.emf.cdo.server.internal.db.ToMany;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceMapping
extends FeatureMapping
implements IReferenceMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, ReferenceMapping.class);
    private static final String SELECT_SUFFIX = " ORDER BY cdo_idx";
    private IDBTable table;
    private ToMany toMany;
    private boolean withFeature;
    private String insertPrefix;
    private String selectPrefix;

    public ReferenceMapping(ClassMapping classMapping, CDOFeature feature, ToMany toMany) {
        super(classMapping, feature);
        this.toMany = toMany;
        this.mapReference(classMapping.getCDOClass(), feature);
        int dbFeatureID = this.withFeature ? FeatureServerInfo.getDBID((CDOModelElement)this.getFeature()) : 0;
        this.insertPrefix = this.createInsertPrefix(dbFeatureID);
        this.selectPrefix = this.createSelectPrefix(dbFeatureID);
    }

    @Override
    public IDBTable getTable() {
        return this.table;
    }

    @Override
    public void writeReference(IDBStoreWriter storeWriter, CDORevision revision) {
        long source = CDOIDUtil.getLong((CDOID)revision.getID());
        int version = revision.getVersion();
        int idx = 0;
        for (Object element : ((InternalCDORevision)revision).getList(this.getFeature())) {
            long target = CDOIDUtil.getLong((CDOID)((CDOID)element));
            StringBuilder builder = new StringBuilder(this.insertPrefix);
            builder.append(source);
            builder.append(", ");
            builder.append(version);
            builder.append(", ");
            builder.append(idx++);
            builder.append(", ");
            builder.append(target);
            builder.append(")");
            String sql = builder.toString();
            ((ClassMapping)this.getClassMapping()).sqlUpdate(storeWriter, sql);
        }
    }

    @Override
    public void readReference(IDBStoreReader storeReader, CDORevision revision, int referenceChunk) {
        MoveableList list = ((InternalCDORevision)revision).getList(this.getFeature());
        CDOID source = revision.getID();
        int version = revision.getVersion();
        String sql = this.createSelect(source, version, null);
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        ResultSet resultSet = null;
        try {
            try {
                resultSet = storeReader.getStatement().executeQuery(sql);
                while (resultSet.next() && (referenceChunk == -1 || --referenceChunk >= 0)) {
                    long target = resultSet.getLong(1);
                    list.add((Object)CDOIDUtil.createLong((long)target));
                }
                while (resultSet.next()) {
                    list.add(InternalCDORevision.UNINITIALIZED);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
    }

    @Override
    public void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        IDBStoreReader storeAccessor = chunkReader.getStoreReader();
        CDOID source = chunkReader.getRevision().getID();
        int version = chunkReader.getRevision().getVersion();
        String sql = this.createSelect(source, version, where);
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        ResultSet resultSet = null;
        try {
            try {
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                resultSet = storeAccessor.getStatement().executeQuery(sql);
                while (resultSet.next()) {
                    long target = resultSet.getLong(1);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                    }
                    chunk.addID(indexInChunk++, CDOIDUtil.createLong((long)target));
                    if (indexInChunk != chunkSize) continue;
                    chunk = null;
                    indexInChunk = 0;
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
    }

    protected String createInsertPrefix(int dbFeatureID) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.table);
        builder.append(" VALUES (");
        if (dbFeatureID != 0) {
            builder.append(FeatureServerInfo.getDBID((CDOModelElement)this.getFeature()));
            builder.append(", ");
        }
        return builder.toString();
    }

    protected String createSelectPrefix(int dbFeatureID) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_target");
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        if (dbFeatureID != 0) {
            builder.append("cdo_feature");
            builder.append("=");
            builder.append(dbFeatureID);
            builder.append(" AND ");
        }
        builder.append("cdo_source");
        builder.append("=");
        return builder.toString();
    }

    protected String createSelect(CDOID source, int version, String where) {
        StringBuilder builder = new StringBuilder(this.selectPrefix);
        builder.append(CDOIDUtil.getLong((CDOID)source));
        builder.append(" AND ");
        builder.append("cdo_version");
        builder.append("=");
        builder.append(version);
        if (where != null) {
            builder.append(where);
        }
        builder.append(SELECT_SUFFIX);
        return builder.toString();
    }

    protected void mapReference(CDOClass cdoClass, CDOFeature cdoFeature) {
        switch (this.toMany) {
            case PER_REFERENCE: {
                this.withFeature = false;
                this.table = this.mapReferenceTable(cdoFeature, String.valueOf(cdoClass.getName()) + "_" + cdoFeature.getName() + "_refs");
                break;
            }
            case PER_CLASS: {
                this.withFeature = true;
                this.table = this.mapReferenceTable(cdoClass, String.valueOf(cdoClass.getName()) + "_refs");
                break;
            }
            case PER_PACKAGE: {
                this.withFeature = true;
                CDOPackage cdoPackage = cdoClass.getContainingPackage();
                this.table = this.mapReferenceTable(cdoPackage, String.valueOf(cdoPackage.getName()) + "_refs");
                break;
            }
            case PER_REPOSITORY: {
                this.withFeature = true;
                IRepository repository = ((ClassMapping)this.getClassMapping()).getMappingStrategy().getStore().getRepository();
                this.table = this.mapReferenceTable(repository, String.valueOf(repository.getName()) + "_refs");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mapping: " + (Object)((Object)this.toMany));
            }
        }
    }

    protected IDBTable mapReferenceTable(Object key, String tableName) {
        Map<Object, IDBTable> referenceTables = ((ClassMapping)this.getClassMapping()).getMappingStrategy().getReferenceTables();
        IDBTable table = referenceTables.get(key);
        if (table == null) {
            table = this.addReferenceTable(tableName);
            referenceTables.put(key, table);
        }
        return table;
    }

    protected IDBTable addReferenceTable(String tableName) {
        IDBTable table = ((ClassMapping)this.getClassMapping()).addTable(tableName);
        if (this.withFeature) {
            table.addField("cdo_feature", DBType.INTEGER);
        }
        table.addField("cdo_source", DBType.BIGINT);
        table.addField("cdo_version", DBType.INTEGER);
        table.addField("cdo_idx", DBType.INTEGER);
        table.addField("cdo_target", DBType.BIGINT);
        return table;
    }
}

