/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public final class CDOClassifierRef {
    public static final String URI_SEPARATOR = "#";
    private String packageURI;
    private String classifierName;

    public CDOClassifierRef() {
    }

    public CDOClassifierRef(EClassifier classifier) {
        this(classifier.getEPackage().getNsURI(), classifier.getName());
    }

    public CDOClassifierRef(String packageURI, String classifierName) {
        this.packageURI = packageURI;
        this.classifierName = classifierName;
    }

    public CDOClassifierRef(CDODataInput in) throws IOException {
        String uri = in.readCDOPackageURI();
        int hash = uri.lastIndexOf(URI_SEPARATOR);
        if (hash == -1) {
            throw new IOException("Invalid classifier URI: " + uri);
        }
        this.packageURI = uri.substring(0, hash);
        this.classifierName = uri.substring(hash + 1);
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOPackageURI(String.valueOf(this.packageURI) + URI_SEPARATOR + this.classifierName);
    }

    public String getPackageURI() {
        return this.packageURI;
    }

    public String getClassifierName() {
        return this.classifierName;
    }

    public EClassifier resolve(EPackage.Registry packageRegistry) {
        EPackage ePackage = packageRegistry.getEPackage(this.packageURI);
        if (ePackage == null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOClassifierRef.0"), this.packageURI));
        }
        return ePackage.getEClassifier(this.classifierName);
    }

    public String toString() {
        return MessageFormat.format("CDOClassifierRef({0}, {1})", this.packageURI, this.classifierName);
    }
}

