/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.Constants;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.mapping.elist.FeatureMapEntryComponentInstantiator;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernateFeatureMapEntry;
import org.eclipse.emf.teneo.hibernate.mapping.property.WildCardAttributePropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.property.WildCardReferencePropertyHandler;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.component.AbstractComponentTuplizer;

public class FeatureMapEntryComponentTuplizer
extends AbstractComponentTuplizer {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(FeatureMapEntryComponentTuplizer.class);

    public FeatureMapEntryComponentTuplizer(Component component) {
        super(component);
    }

    protected Instantiator buildInstantiator(Component component) {
        return new FeatureMapEntryComponentInstantiator(component);
    }

    protected Getter buildGetter(Component component, Property prop) {
        return this.getPropertyAccessor(prop, component).getGetter(component.getComponentClass(), prop.getName());
    }

    protected Setter buildSetter(Component component, Property prop) {
        return this.getPropertyAccessor(prop, component).getSetter(component.getComponentClass(), prop.getName());
    }

    protected PropertyAccessor getPropertyAccessor(Property mappedProperty, Component component) {
        HbDataStore hds = HbHelper.INSTANCE.getDataStore(component.getOwner());
        if (mappedProperty.getMetaAttribute("syntheticVersion") != null) {
            return hds.getHbContext().createVersionAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_feature") == 0) {
            return hds.getHbContext().createFeatureMapEntryFeatureURIAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_mixed_cdata") == 0) {
            return hds.getHbContext().createFeatureMapEntryAccessor(Constants.CDATA);
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_mixed_comment") == 0) {
            return hds.getHbContext().createFeatureMapEntryAccessor(Constants.COMMENT);
        }
        if (mappedProperty.getName().compareToIgnoreCase("fme_mixed_text") == 0) {
            return hds.getHbContext().createFeatureMapEntryAccessor(Constants.TEXT);
        }
        if (mappedProperty.getName().endsWith("fme_any_data")) {
            return (PropertyAccessor)hds.getExtensionManager().getExtension(WildCardAttributePropertyHandler.class);
        }
        if (mappedProperty.getName().endsWith("fme_any_reference")) {
            return (PropertyAccessor)hds.getExtensionManager().getExtension(WildCardReferencePropertyHandler.class);
        }
        MetaAttribute ma = component.getMetaAttribute("featureMap");
        String eclassUri = ma.getValue();
        EClass eClass = hds.getEntityNameStrategy().toEClass(eclassUri);
        EStructuralFeature efeature = StoreUtil.getEStructuralFeature((EClass)eClass, (String)mappedProperty.getName());
        if (efeature == null) {
            throw new HbMapperException("Feature not found for property " + mappedProperty.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating property accessor for " + mappedProperty.getName() + "/" + eclassUri + "/" + efeature.getName()));
        }
        return hds.getHbContext().createFeatureMapEntryAccessor(efeature);
    }

    public Class getMappedClass() {
        return HibernateFeatureMapEntry.class;
    }
}

