/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.platform.Sensor;
import org.eclipse.mita.platform.xdk110.sensors.Bme280Generator;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Bme280Validator
implements IResourceValidator {
    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        SystemResourceSetup sensorSetup = ModelUtils.findSetupFor((Program)program, Sensor.class, (String)"BME280");
        if (sensorSetup == null) {
            return;
        }
        Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

            public Boolean apply(ConfigurationItemValue x) {
                String _name = x.getItem().getName();
                return Objects.equal((Object)_name, (Object)"standby_time");
            }
        };
        ConfigurationItemValue standbyItem = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)sensorSetup.getConfigurationItemValues(), (Functions.Function1)_function);
        if (standbyItem != null) {
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject x) {
                }
            };
            Object specifiedTime = StaticValueInferrer.infer((EObject)standbyItem.getValue(), (Procedures.Procedure1)_function_1);
            if (specifiedTime instanceof Integer) {
                Integer producedTime;
                boolean _notEquals;
                Pair<Integer, String> _clipStandbyTime = Bme280Generator.clipStandbyTime((Integer)specifiedTime);
                Integer _key = null;
                if (_clipStandbyTime != null) {
                    _key = (Integer)_clipStandbyTime.getKey();
                }
                boolean bl = _notEquals = !Objects.equal((Object)(producedTime = _key), (Object)specifiedTime);
                if (_notEquals) {
                    acceptor.acceptInfo(String.format("Standby time will be rounded to the nearest configurable value of %s milliseconds", producedTime), (EObject)standbyItem, (EStructuralFeature)ProgramPackage.eINSTANCE.getConfigurationItemValue_Value(), -1, "BME280_STANDBYTIME_CFG_ROUND", new String[0]);
                }
            }
        }
    }
}

