/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.Event;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.SystemResourceEvent;
import org.eclipse.mita.platform.xdk110.platform.EventLoopGenerator;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Bma280Generator
extends AbstractSystemResourceGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected EventLoopGenerator eventLoopGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Extract BMA280 Handle from Advanced API */");
                _builder.newLine();
                _builder.append((Object)"Bma280Utils_InfoPtr_T bma280UtilityCfg = xdkAccelerometers_BMA280_Handle->SensorPtr;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Register Callback */");
                _builder.newLine();
                _builder.append((Object)"bma280UtilityCfg->ISRCallback = BMA280_IsrCallback;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"retcode = Bma280Utils_initialize(bma280UtilityCfg);");
                _builder.newLine();
                _builder.append((Object)"if(retcode != RETCODE_OK)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"return retcode;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Do soft reset and wait 2-3 ms */");
                _builder.newLine();
                _builder.append((Object)"// bma2x2_soft_rst();");
                _builder.newLine();
                _builder.append((Object)"/* Overwrite settings */");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Block One: Basic Settings */");
                _builder.newLine();
                _builder.append((Object)"/* Required: Set power mode to normal for configuration */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_power_mode(BMA2x2_MODE_NORMAL);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Set Bandwidth */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_bw(");
                String _bmaEnumValue = Bma280Generator.this.getBmaEnumValue(Bma280Generator.this.configuration, "bandwidth");
                _builder.append((Object)_bmaEnumValue);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/* Setting to filtered low-bandwidth */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_high_bw(1);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Set Range */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_range(");
                String _bmaEnumValue_1 = Bma280Generator.this.getBmaEnumValue(Bma280Generator.this.configuration, "range");
                _builder.append((Object)_bmaEnumValue_1);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/* Set Sleep Duration */");
                _builder.newLine();
                _builder.append((Object)"//bma2x2_set_sleep_durn(BMA2x2_SLEEP_DURN_1S);");
                _builder.newLine();
                _builder.append((Object)"//bma2x2_set_sleep_timer_mode(0);");
                _builder.newLine();
                _builder.append((Object)"/* Set Interrupt latch and level */");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Output stages */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_latch_intr(BMA2x2_LATCH_DURN_250MS);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_level(BMA2x2_INTR1_LEVEL, ACTIVE_LOW);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_level(BMA2x2_INTR2_LEVEL, ACTIVE_LOW);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_output_type(BMA2x2_INTR1_OUTPUT, PUSS_PULL);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_output_type(BMA2x2_INTR2_OUTPUT, PUSS_PULL);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Set power mode to target value */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_power_mode(BMA2x2_MODE_NORMAL);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Group 1: INTR1 Settings */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_low_g(BMA2x2_INTR1_LOW_G, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_high_g(BMA2x2_INTR1_HIGH_G, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_slope(BMA2x2_INTR1_SLOPE, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_slow_no_motion(BMA2x2_INTR1_SLOW_NO_MOTION, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_double_tap(BMA2x2_INTR1_DOUBLE_TAP, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_single_tap(BMA2x2_INTR1_SINGLE_TAP, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_orient(BMA2x2_INTR1_ORIENT, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_flat(BMA2x2_INTR1_FLAT, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_new_data(BMA2x2_INTR1_NEWDATA, INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr1_fifo_wm(INTR_ENABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr1_fifo_full(INTR_ENABLE);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Group 2: INTR2 Settings */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_low_g(BMA2x2_INTR2_LOW_G, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_high_g(BMA2x2_INTR2_HIGH_G, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_slope(BMA2x2_INTR2_SLOPE, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_slow_no_motion(BMA2x2_INTR2_SLOW_NO_MOTION, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_double_tap(BMA2x2_INTR2_DOUBLE_TAP, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_single_tap(BMA2x2_INTR2_SINGLE_TAP, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_orient(BMA2x2_INTR2_ORIENT, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr_flat(BMA2x2_INTR2_FLAT, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_new_data(BMA2x2_INTR2_NEWDATA, INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr2_fifo_wm(INTR_DISABLE);");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_intr2_fifo_full(INTR_DISABLE);");
                _builder.newLine();
                _builder.newLine();
                boolean _containsHandlerFor = Bma280Generator.this.containsHandlerFor(Bma280Generator.this.eventHandler, "log_g");
                if (_containsHandlerFor) {
                    _builder.append((Object)"/* low-g  */");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_thres(BMA2x2_LOW_THRES, BMA2x2_LOW_THRES_IN_G(0.4, 2.0));");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_durn( BMA2x2_LOW_DURN, 10);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_low_high_g_hyst(BMA2x2_LOW_G_HYST, BMA2x2_LOW_HYST_IN_G(0.1, 2.0));");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_low_g_mode(LOW_G_SUMMING_MODE);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_source(BMA2x2_SOURCE_LOW_G, 0); /* Data source for interrupt engine */");
                    _builder.newLine();
                }
                _builder.newLine();
                boolean _containsHandlerFor_1 = Bma280Generator.this.containsHandlerFor(Bma280Generator.this.eventHandler, "high_g");
                if (_containsHandlerFor_1) {
                    _builder.append((Object)"/* high-g  */");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_thres(BMA2x2_HIGH_THRES, BMA2x2_HIGH_THRES_IN_G(1.5, 2.0));");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_durn( BMA2x2_HIGH_DURN, 10);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_low_high_g_hyst(BMA2x2_HIGH_G_HYST, BMA2x2_HIGH_HYST_IN_G(0.5, 2.0));");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_source(BMA2x2_SOURCE_HIGH_G, 0); /* Data source for interrupt engine */");
                    _builder.newLine();
                }
                _builder.newLine();
                boolean _containsHandlerFor_2 = Bma280Generator.this.containsHandlerFor(Bma280Generator.this.eventHandler, "any_motion");
                if (_containsHandlerFor_2) {
                    _builder.append((Object)"/* any motion */");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_thres(BMA2x2_SLOPE_THRES, ");
                    Integer _integer = Bma280Generator.this.configuration.getInteger("any_motion_threshold");
                    _builder.append((Object)_integer);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"bma2x2_set_durn(BMA2x2_SLOPE_DURN, 0);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_source(BMA2x2_SOURCE_SLOPE, 0); /* Data source for interrupt engine */");
                    _builder.newLine();
                }
                _builder.newLine();
                boolean _containsHandlerFor_3 = Bma280Generator.this.containsHandlerFor(Bma280Generator.this.eventHandler, "no_motion");
                if (_containsHandlerFor_3) {
                    _builder.append((Object)"/* no motion */");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_thres(BMA2x2_SLOW_NO_MOTION_THRES, ");
                    Integer _integer_1 = Bma280Generator.this.configuration.getInteger("no_motion_threshold");
                    _builder.append((Object)_integer_1);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"bma2x2_set_durn(BMA2x2_SLOW_NO_MOTION_DURN, 1);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_X, INTR_ENABLE);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_Y, INTR_ENABLE);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_Z, INTR_ENABLE);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_SELECT, INTR_ENABLE);");
                    _builder.newLine();
                }
                _builder.newLine();
                if (Bma280Generator.this.containsHandlerFor(Bma280Generator.this.eventHandler, "single_tap") || Bma280Generator.this.containsHandlerFor(Bma280Generator.this.eventHandler, "double_tap")) {
                    _builder.append((Object)"/* single-tap double-tap */");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_tap_durn(TAP_DURN_250_MS);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_tap_quiet(TAP_QUIET_30_MS);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_tap_thres((1.25 * 32 / 2.0)); //1250mg");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_tap_shock(TAP_SHOCK_50_MS);");
                    _builder.newLine();
                    _builder.append((Object)"bma2x2_set_source(BMA2x2_SOURCE_TAP, 0);");
                    _builder.newLine();
                    _builder.append((Object)"//bma2x2_set_tap_sample( 0x02 );");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append((Object)"/* orientation */");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* flat */");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* New data */");
                _builder.newLine();
                _builder.append((Object)"bma2x2_set_source(BMA2x2_SOURCE_DATA, 0);");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not_2;
                boolean _not_1;
                boolean _not;
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* BMA280 ISR Callback */");
                _builder.newLine();
                _builder.append((Object)"static void BMA280_IsrCallback(uint32_t channel, uint32_t edge);");
                _builder.newLine();
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Bma280Generator.this.eventHandler);
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.newLine();
                    _builder.append((Object)"/* BMA280 Event Resolver */");
                    _builder.newLine();
                    _builder.append((Object)"static Retcode_T BMA280_Event(void * param1, uint32_t param2);");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append((Object)"static void BMA280_IsrCallback(uint32_t channel, uint32_t edge)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BCDS_UNUSED(channel);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BCDS_UNUSED(edge);");
                _builder.newLine();
                boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)Bma280Generator.this.eventHandler);
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"/* Enqueue Event Resolver */");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    CodeFragment _generateEventloopInjectFromIsr = Bma280Generator.this.eventLoopGenerator.generateEventloopInjectFromIsr("BMA280_Event", "NULL", "0");
                    _builder.append((Object)_generateEventloopInjectFromIsr, "    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)Bma280Generator.this.eventHandler);
                boolean bl3 = _not_2 = !_isEmpty_2;
                if (_not_2) {
                    _builder.append((Object)"static Retcode_T BMA280_Event(void* param1, uint32_t param2)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"(void) param1;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"(void) param2;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"/* Read from interrupt status information */");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"uint8_t interruptSource[4];");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"(void) bma2x2_get_intr_stat(interruptSource);");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"/* Trigger the corresponding event depending on the ISR mask */");
                    _builder.newLine();
                    for (EventHandlerDeclaration eventHandler : Bma280Generator.this.eventHandler) {
                        _builder.append((Object)"    ");
                        CodeFragment _generateEventDispatch = Bma280Generator.this.generateEventDispatch(eventHandler);
                        _builder.append((Object)_generateEventDispatch, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return RETCODE_OK;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("BCDS_Basics.h", true, 1250).addHeader("BCDS_CmdProcessor.h", true).addHeader("XdkSensorHandle.h", true).addHeader("bma2x2.h", true).addHeader("BCDS_Bma280Utils.h", true).addHeader("MitaEvents.h", false);
    }

    public String getBmaEnumValue(IComponentConfiguration config, String configItemName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("BMA2x2_");
        Enumerator _enumerator = config.getEnumerator(configItemName);
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String _upperCase = null;
        if (_name != null) {
            _upperCase = _name.toUpperCase();
        }
        _builder.append(_upperCase);
        return _builder.toString();
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/* Enable Active Sensor Events */");
                _builder.newLine();
                for (EventHandlerDeclaration handler : Bma280Generator.this.eventHandler) {
                    EventSource _event = handler.getEvent();
                    Event _source = ((SystemEventSource)_event).getSource();
                    String _enableInterrupt = Bma280Generator.this.enableInterrupt((SystemResourceEvent)_source);
                    _builder.append((Object)_enableInterrupt);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public boolean containsHandlerFor(Iterable<EventHandlerDeclaration> handler, final String name) {
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration x) {
                EventSource _event = x.getEvent();
                String _name = ((SystemEventSource)_event).getSource().getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        EventHandlerDeclaration _findFirst = (EventHandlerDeclaration)IterableExtensions.findFirst(handler, (Functions.Function1)_function);
        return _findFirst != null;
    }

    public CodeFragment generateAccessPreparationFor(final ModalityAccessPreparation accessPreparation) {
        int uid = accessPreparation.hashCode();
        final String dataVariable = StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)accessPreparation));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"struct bma2x2_accel_data ");
                _builder.append((Object)dataVariable);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = ");
                CharSequence _readXyzName = Bma280Generator.this.getReadXyzName(Bma280Generator.this.component);
                _builder.append((Object)_readXyzName);
                _builder.append((Object)"(&");
                _builder.append((Object)dataVariable);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = Bma280Generator.this._generatorUtils.generateExceptionHandler((EObject)accessPreparation, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        CodeFragment _addHeader = this.codeFragmentProvider.create(_client).addHeader("bma2x2.h", true);
        StringConcatenation _builder = new StringConcatenation();
        String _fileBasename = this._generatorUtils.getFileBasename((EObject)this.component);
        _builder.append(_fileBasename);
        _builder.append(".h");
        return _addHeader.addHeader(_builder.toString(), false);
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess access) {
        final String dataVariable = StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)access.getPreparation()));
        CodeFragment _switchResult = null;
        String _name = access.getModality().getName();
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)"x_axis")) {
            _matched = true;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".x");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"y_axis")) {
            _matched = true;
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".y");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_1);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"z_axis")) {
            _matched = true;
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".z");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_2);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"magnitude")) {
            _matched = true;
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"(uint32_t)sqrt((");
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".x * ");
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".x) + (");
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".y * ");
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".y) + (");
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".z * ");
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".z))");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_3).addHeader("math.h", true).addHeader("BCDS_Basics.h", true);
        }
        if (!_matched) {
            Modality _modality = access.getModality();
            String _plus = "Unsupported modality " + _modality;
            throw new UnsupportedOperationException(_plus);
        }
        CodeFragment result = _switchResult;
        return result.addHeader("bma2x2.h", true);
    }

    public CodeFragment generateAdditionalHeaderContent() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T ");
                CharSequence _readXyzName = Bma280Generator.this.getReadXyzName(Bma280Generator.this.component);
                _builder.append((Object)_readXyzName);
                _builder.append((Object)"(struct bma2x2_accel_data* result);");
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("bma2x2.h", true);
    }

    public CodeFragment generateAdditionalImplementation() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T ");
                CharSequence _readXyzName = Bma280Generator.this.getReadXyzName(Bma280Generator.this.component);
                _builder.append((Object)_readXyzName);
                _builder.append((Object)"(struct bma2x2_accel_data* result)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{    ");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"// read sensor data");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BMA2x2_RETURN_FUNCTION_TYPE bmaReadRc = bma2x2_read_accel_xyz(result);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if(bmaReadRc != 0)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_FAILURE);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"// remap to XDK axis alignment");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"AxisRemap_Data_T axisRemapping = { INT32_C(0), INT32_C(0), INT32_C(0) };");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"axisRemapping.x = result->x;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"axisRemapping.y = result->y;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"axisRemapping.z = result->z;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"Retcode_T remappingStatus = Bma280Utils_remapAxis((Bma280Utils_InfoPtr_T) xdkAccelerometers_BMA280_Handle->SensorPtr, &axisRemapping);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"// store in result");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (RETCODE_OK == remappingStatus)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"result->x = axisRemapping.x;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"result->y = axisRemapping.y;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"result->z = axisRemapping.z;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"return RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"return remappingStatus;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("bma2x2.h", true).addHeader("BCDS_Bma280Utils.h", true);
    }

    private CharSequence getReadXyzName(AbstractSystemResource context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this._generatorUtils.getBaseName((Object)context);
        _builder.append(_baseName);
        _builder.append("_ReadXYZ");
        return _builder;
    }

    private CodeFragment generateEventDispatch(final EventHandlerDeclaration handler) {
        String basename = this._generatorUtils.getBaseName((Object)handler).toUpperCase();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(basename);
        _builder.append("_CODE");
        String eventName = _builder.toString();
        Pair _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)basename, (Object)"ACCELEROMETERANY_MOTION")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_SLOPE_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERNO_MOTION")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_SLOW_NO_MOTION_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERLOW_G")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_LOW_G_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERHIGH_G")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_HIGH_G_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERSINGLE_TAP")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_SINGLE_TAP_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERDOUBLE_TAP")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_DOUBLE_TAP_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERFLAT")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_FLAT_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERORIENTATION")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_ORIENT_INTR_STAT_MSK", (Object)"BMA2x2_STAT1");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERFIFO_FULL")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_FIFO_FULL_INTR_STAT_MSK", (Object)"BMA2x2_STAT2");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERFIFO_WML")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_FIFO_WM_INTR_STAT_MSK", (Object)"BMA2x2_STAT2");
        }
        if (!_matched && Objects.equal((Object)basename, (Object)"ACCELEROMETERNEW_DATA")) {
            _matched = true;
            _switchResult = Pair.of((Object)"BMA2x2_DATA_INTR_STAT_MSK", (Object)"BMA2x2_STAT2");
        }
        Pair bitMaskAndstatusByte = _switchResult;
        final String bitMask = (String)bitMaskAndstatusByte.getKey();
        final String statusByte = (String)bitMaskAndstatusByte.getValue();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(interruptSource[");
                _builder.append((Object)statusByte);
                _builder.append((Object)"] & ");
                _builder.append((Object)bitMask);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                CodeFragment _generateEventloopInject = Bma280Generator.this.eventLoopGenerator.generateEventloopInject(Bma280Generator.this._generatorUtils.getHandlerName((EObject)handler), "NULL", "0");
                _builder.append((Object)_generateEventloopInject, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    private String enableInterrupt(SystemResourceEvent event) {
        String _switchResult = null;
        String _upperCase = this._generatorUtils.getBaseName((Object)event).toUpperCase();
        boolean _matched = false;
        if (Objects.equal((Object)_upperCase, (Object)"BMA280ANY_MOTION")) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("bma2x2_set_intr_enable(BMA2x2_SLOPE_X_INTR, INTR_ENABLE);");
            _builder.newLine();
            _builder.append("bma2x2_set_intr_enable(BMA2x2_SLOPE_Y_INTR, INTR_ENABLE);");
            _builder.newLine();
            _builder.append("bma2x2_set_intr_enable(BMA2x2_SLOPE_Z_INTR, INTR_ENABLE);");
            _builder.newLine();
            _switchResult = _builder.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280NO_MOTION")) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_X, INTR_ENABLE);");
            _builder_1.newLine();
            _builder_1.append("bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_Y, INTR_ENABLE);");
            _builder_1.newLine();
            _builder_1.append("bma2x2_set_slow_no_motion(BMA2x2_SLOW_NO_MOTION_ENABLE_Z, INTR_ENABLE);");
            _builder_1.newLine();
            _switchResult = _builder_1.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280LOW_G")) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("bma2x2_set_intr_enable(BMA2x2_LOW_G_INTR, INTR_ENABLE);");
            _builder_2.newLine();
            _switchResult = _builder_2.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280HIGH_G")) {
            _matched = true;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("bma2x2_set_intr_enable(BMA2x2_HIGH_G_X_INTR, INTR_ENABLE);");
            _builder_3.newLine();
            _builder_3.append("bma2x2_set_intr_enable(BMA2x2_HIGH_G_Y_INTR, INTR_ENABLE);");
            _builder_3.newLine();
            _builder_3.append("bma2x2_set_intr_enable(BMA2x2_HIGH_G_Z_INTR, INTR_ENABLE);");
            _builder_3.newLine();
            _switchResult = _builder_3.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280SINGLE_TAP")) {
            _matched = true;
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("bma2x2_set_intr_enable(BMA2x2_SINGLE_TAP_INTR, INTR_ENABLE);");
            _builder_4.newLine();
            _switchResult = _builder_4.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280DOUBLE_TAP")) {
            _matched = true;
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("bma2x2_set_intr_enable(BMA2x2_DOUBLE_TAP_INTR, INTR_ENABLE);");
            _builder_5.newLine();
            _switchResult = _builder_5.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280FLAT")) {
            _matched = true;
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append("bma2x2_set_intr_enable(BMA2x2_FLAT_INTR, INTR_ENABLE);");
            _builder_6.newLine();
            _switchResult = _builder_6.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280ORIENTATION")) {
            _matched = true;
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append("bma2x2_set_intr_enable(BMA2x2_ORIENT_INTR, INTR_ENABLE);");
            _builder_7.newLine();
            _switchResult = _builder_7.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280FIFO_FULL")) {
            _matched = true;
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append("bma2x2_set_intr_enable(BMA2x2_FIFO_FULL_INTR, INTR_ENABLE);");
            _builder_8.newLine();
            _switchResult = _builder_8.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280FIFO_WML")) {
            _matched = true;
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append("bma2x2_set_intr_enable(BMA2x2_FIFO_WM_INTR, INTR_ENABLE);");
            _builder_9.newLine();
            _switchResult = _builder_9.toString();
        }
        if (!_matched && Objects.equal((Object)_upperCase, (Object)"BMA280NEW_DATA")) {
            _matched = true;
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append("bma2x2_set_intr_enable(BMA2x2_FIFO_FULL_INTR, INTR_ENABLE);");
            _builder_10.newLine();
            _switchResult = _builder_10.toString();
        }
        String activation = _switchResult;
        StringConcatenation _builder_11 = new StringConcatenation();
        _builder_11.append("/* Activating ");
        String _name = event.getName();
        _builder_11.append(_name);
        _builder_11.append(" */");
        _builder_11.newLineIfNotEmpty();
        _builder_11.append(activation);
        _builder_11.newLineIfNotEmpty();
        _builder_11.newLine();
        return _builder_11.toString();
    }
}

