/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.common.base.Objects;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.IPlatformMakefileGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MakefileGenerator
implements IPlatformMakefileGenerator {
    @Inject
    private CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateMakefile(Iterable<Program> compilationUnits, final List<String> sourceFiles) {
        Procedures.Procedure1<EObject> _function_4;
        Object _infer_1;
        Procedures.Procedure1<EObject> _function_2;
        Object _infer;
        Iterable _flatMap = null;
        if (compilationUnits != null) {
            Functions.Function1<Program, EList<SystemResourceSetup>> _function = new Functions.Function1<Program, EList<SystemResourceSetup>>(){

                public EList<SystemResourceSetup> apply(Program it) {
                    return it.getSetup();
                }
            };
            _flatMap = IterableExtensions.flatMap(compilationUnits, (Functions.Function1)_function);
        }
        Iterable setups = _flatMap;
        Object _elvis = null;
        SystemResourceSetup _findFirst = null;
        if (setups != null) {
            Functions.Function1<SystemResourceSetup, Boolean> _function_1 = new Functions.Function1<SystemResourceSetup, Boolean>(){

                public Boolean apply(SystemResourceSetup it) {
                    String _name = it.getType().getName();
                    return Objects.equal((Object)_name, (Object)"XDK110");
                }
            };
            _findFirst = (SystemResourceSetup)IterableExtensions.findFirst((Iterable)setups, (Functions.Function1)_function_1);
        }
        Expression _configurationItemValue = null;
        if (_findFirst != null) {
            _configurationItemValue = _findFirst.getConfigurationItemValue("applicationName");
        }
        _elvis = (_infer = StaticValueInferrer.infer((EObject)_configurationItemValue, (Procedures.Procedure1)(_function_2 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        }))) != null ? _infer : "EclipseMitaApplication";
        final Object appName = _elvis;
        String _elvis_1 = null;
        SystemResourceSetup _findFirst_1 = null;
        if (setups != null) {
            Functions.Function1<SystemResourceSetup, Boolean> _function_3 = new Functions.Function1<SystemResourceSetup, Boolean>(){

                public Boolean apply(SystemResourceSetup it) {
                    return Objects.equal((Object)it.getType().getName(), (Object)"MQTT") || Objects.equal((Object)it.getType().getName(), (Object)"HonoMqtt");
                }
            };
            _findFirst_1 = (SystemResourceSetup)IterableExtensions.findFirst((Iterable)setups, (Functions.Function1)_function_3);
        }
        Expression _configurationItemValue_1 = null;
        if (_findFirst_1 != null) {
            _configurationItemValue_1 = _findFirst_1.getConfigurationItemValue("url");
        }
        _elvis_1 = (String)(_infer_1 = StaticValueInferrer.infer((EObject)_configurationItemValue_1, (Procedures.Procedure1)(_function_4 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        }))) != null ? (String)_infer_1 : "";
        final boolean isSecure = _elvis_1.startsWith("mqtts");
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"# This makefile triggers the targets in the application.mk");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"# The default value \"../../..\" assumes that this makefile is placed in the ");
                _builder.newLine();
                _builder.append((Object)"# folder xdk110/Apps/<App Folder> where the BCDS_BASE_DIR is the parent of ");
                _builder.newLine();
                _builder.append((Object)"# the xdk110 folder.");
                _builder.newLine();
                _builder.append((Object)"BCDS_BASE_DIR ?= ../../..");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"# Macro to define Start-up method. change this macro to \"CUSTOM_STARTUP\" to have custom start-up.");
                _builder.newLine();
                _builder.append((Object)"export BCDS_SYSTEM_STARTUP_METHOD = DEFAULT_STARTUP");
                _builder.newLine();
                _builder.append((Object)"export BCDS_APP_NAME = ");
                _builder.append(appName);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"export BCDS_APP_DIR = $(CURDIR)");
                _builder.newLine();
                _builder.append((Object)"export BCDS_APP_SOURCE_DIR = $(BCDS_APP_DIR)");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"#Please refer BCDS_CFLAGS_COMMON variable in application.mk file");
                _builder.newLine();
                _builder.append((Object)"#and if any addition flags required then add that flags only in the below macro ");
                _builder.newLine();
                _builder.append((Object)"#export BCDS_CFLAGS_COMMON = ");
                _builder.newLine();
                _builder.newLine();
                if (isSecure) {
                    _builder.append((Object)"export SERVAL_TLS_MBEDTLS=1");
                    _builder.newLine();
                    _builder.append((Object)"export SERVAL_ENABLE_TLS_CLIENT=1");
                    _builder.newLine();
                    _builder.append((Object)"export SERVAL_ENABLE_TLS_ECC=1");
                    _builder.newLine();
                    _builder.append((Object)"export SERVAL_ENABLE_TLS_PSK=0");
                    _builder.newLine();
                    _builder.append((Object)"export SERVAL_MAX_NUM_MESSAGES=8");
                    _builder.newLine();
                    _builder.append((Object)"export SERVAL_MAX_SIZE_APP_PACKET=900");
                    _builder.newLine();
                    _builder.append((Object)"export SERVAL_ENABLE_TLS=1");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"export XDK_MBEDTLS_PARSE_INFO=0");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append((Object)"#List all the application header file under variable BCDS_XDK_INCLUDES ");
                _builder.newLine();
                _builder.append((Object)"export BCDS_XDK_INCLUDES = \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Libraries/BSTLib/3rd-party/bstlib/BMA2x2_driver \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Platform/BSP/source \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_APP_SOURCE_DIR) \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_APP_SOURCE_DIR)/.. \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_APP_SOURCE_DIR)/base \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Common/include \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Common/certs/XDKDummy \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Common/source/Private/ServalStack/src/TLS_MbedTLS \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Common/source \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Common/source/Connectivity \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"-I$(BCDS_BASE_DIR)/xdk110/Platform/BSP/source");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"#List all the application source file under variable BCDS_XDK_APP_SOURCE_FILES in a similar pattern as below");
                _builder.newLine();
                _builder.append((Object)"export BCDS_XDK_APP_SOURCE_FILES = \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String x) {
                        return x.endsWith(".c");
                    }
                };
                Functions.Function1<String, String> _function_1 = new Functions.Function1<String, String>(){

                    public String apply(String x) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("$(BCDS_APP_SOURCE_DIR)/");
                        _builder.append(x);
                        return _builder.toString();
                    }
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)sourceFiles, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)" \\\n");
                _builder.append((Object)_join, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)".PHONY: clean debug release flash_debug_bin flash_release_bin");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"clean: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk clean");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"debug: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk debug");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"release: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk release");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"flash_debug_bin: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk flash_debug_bin");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"flash_release_bin: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk flash_release_bin");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"cleanlint: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk cleanlint");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"lint: ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk lint");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"cdt:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(MAKE) -C $(BCDS_BASE_DIR)/xdk110/Common -f application.mk cdt\t");
                _builder.newLine();
                _builder.newLine();
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

