/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class EventLoopGenerator
implements IPlatformEventLoopGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected StatementGenerator statementGenerator;
    @Inject
    @Extension
    protected GeneratorUtils generatorUtils;

    public CodeFragment generateEventloopInject(final String functionName, final String userParam1, final String userParam2) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"CmdProcessor_Enqueue(&Mita_EventQueue, ");
                _builder.append((Object)functionName);
                _builder.append((Object)", ");
                _builder.append((Object)userParam1);
                _builder.append((Object)", ");
                _builder.append((Object)userParam2);
                _builder.append((Object)");");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_CmdProcessor.h", true);
    }

    public CodeFragment generateEventloopInjectFromIsr(final String functionName, final String userParam1, final String userParam2) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"CmdProcessor_EnqueueFromIsr(&Mita_EventQueue, ");
                _builder.append((Object)functionName);
                _builder.append((Object)", ");
                _builder.append((Object)userParam1);
                _builder.append((Object)", ");
                _builder.append((Object)userParam2);
                _builder.append((Object)");");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_CmdProcessor.h", true);
    }

    public CodeFragment generateEventloopInject(String functionName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("NULL");
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("0");
        return this.generateEventloopInject(functionName, _builder.toString(), _builder_1.toString());
    }

    public CodeFragment generateEventLoopInject(CompilationContext context, String functionName) {
        return this.generateEventloopInject(functionName);
    }

    public CodeFragment generateEventLoopStart(CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"BSP_BoardDelay(0);");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEventHeaderPreamble(CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"extern CmdProcessor_T Mita_EventQueue;");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_CmdProcessor.h", true);
    }

    public CodeFragment generateEventLoopHandlerSignature(CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"void* userParameter1, uint32_t userParameter2");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true);
    }

    public CodeFragment generateEventLoopHandlerPreamble(CompilationContext context, EventHandlerDeclaration handler) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"BCDS_UNUSED(userParameter1);");
                _builder.newLine();
                _builder.append((Object)"BCDS_UNUSED(userParameter2);");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true);
    }

    public CodeFragment generateSetupPreamble(CompilationContext context) {
        Functions.Function1<Program, List<SystemResourceSetup>> _function = new Functions.Function1<Program, List<SystemResourceSetup>>(){

            public List<SystemResourceSetup> apply(Program it) {
                return IterableExtensions.toList((Iterable)it.getSetup());
            }
        };
        Functions.Function1<SystemResourceSetup, Boolean> _function_1 = new Functions.Function1<SystemResourceSetup, Boolean>(){

            public Boolean apply(SystemResourceSetup it) {
                AbstractSystemResource _type = it.getType();
                String _name = null;
                if (_type != null) {
                    _name = _type.getName();
                }
                return Objects.equal((Object)_name, (Object)"XDK110");
            }
        };
        SystemResourceSetup platformSetup = (SystemResourceSetup)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap((Iterable)context.getAllUnits(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (platformSetup == null) {
            return CodeFragment.EMPTY;
        }
        final Expression startupDelay = platformSetup.getConfigurationItemValue("startupDelay");
        Procedures.Procedure1<EObject> _function_2 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object powerExternalDevices = StaticValueInferrer.infer((EObject)platformSetup.getConfigurationItemValueOrDefault("powerExternalDevices"), (Procedures.Procedure1)_function_2);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (startupDelay != null) {
                    _builder.append((Object)"BSP_Board_Delay(");
                    IGeneratorNode _code = EventLoopGenerator.this.statementGenerator.code((EObject)startupDelay);
                    _builder.append((Object)_code);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                if (powerExternalDevices instanceof Boolean && ((Boolean)powerExternalDevices).booleanValue()) {
                    _builder.append((Object)"exception = BSP_ExtensionPort_Connect();");
                    _builder.newLine();
                    CodeFragment _generateLoggingExceptionHandler = EventLoopGenerator.this.generatorUtils.generateLoggingExceptionHandler("ExtensionPortPower", "enable");
                    _builder.append((Object)_generateLoggingExceptionHandler);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_BSP_Board.h", true).addHeader("BSP_ExtensionPort.h", true);
    }

    public CodeFragment generateEnablePreamble(CompilationContext context) {
        return CodeFragment.EMPTY;
    }
}

