/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public interface IValidationIssueAcceptor {
    public void accept(ValidationIssue var1);

    public static final class ListBasedValidationIssueAcceptor
    implements IValidationIssueAcceptor {
        private List<ValidationIssue> traces = Lists.newArrayList();

        @Override
        public void accept(ValidationIssue trace) {
            this.traces.add(trace);
        }

        public List<ValidationIssue> getTraces() {
            return this.traces;
        }

        public List<ValidationIssue> getTraces(final ValidationIssue.Severity severity) {
            return Lists.newArrayList((Iterable)Iterables.filter(this.traces, (Predicate)new Predicate<ValidationIssue>(){

                public boolean apply(ValidationIssue input) {
                    return input.getSeverity() == severity;
                }
            }));
        }
    }

    public static class ValidationIssue {
        private Severity severity;
        private String message;
        private String issueCode;
        private EObject target;
        private EStructuralFeature feature;

        public ValidationIssue(Severity severity, String message, String issueCode) {
            this(severity, message, null, null, issueCode);
        }

        public ValidationIssue(Severity severity, String message, EObject target, EStructuralFeature feature, String issueCode) {
            Assert.isNotNull((Object)message);
            Assert.isNotNull((Object)issueCode);
            Assert.isNotNull((Object)((Object)severity));
            this.severity = severity;
            this.message = message;
            this.target = target;
            this.issueCode = issueCode;
            this.feature = feature;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public EObject getTarget() {
            return this.target;
        }

        public void setTarget(EObject target) {
            this.target = target;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public void setFeature(EStructuralFeature feature) {
            this.feature = feature;
        }

        public String getIssueCode() {
            return this.issueCode;
        }

        public String toString() {
            return "ValidationIssue [severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", issueCode=" + this.issueCode + ", target=" + this.target + "]";
        }

        public static enum Severity {
            ERROR,
            WARNING,
            INFO;

        }
    }
}

