/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.scoping;

import java.util.LinkedList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.scoping.ILibraryProvider;
import org.eclipse.mita.base.types.ImportStatement;
import org.eclipse.mita.library.extension.LibraryExtensions;

public class LibraryProviderImpl
implements ILibraryProvider {
    @Override
    public Iterable<URI> getDefaultLibraries() {
        LinkedList<URI> result = new LinkedList<URI>();
        for (LibraryExtensions.LibraryDescriptor desc : LibraryExtensions.getDefaultLibraries()) {
            result.addAll(desc.getResourceUris());
        }
        return result;
    }

    @Override
    public Iterable<URI> getImportedLibraries(Resource context) {
        LinkedList<URI> result = new LinkedList<URI>();
        TreeIterator allContents = context.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof ImportStatement)) continue;
            String importedNamespace = ((ImportStatement)next).getImportedNamespace();
            Iterable importsDescriptors = LibraryExtensions.getDescriptors((String)importedNamespace);
            for (LibraryExtensions.LibraryDescriptor desc : importsDescriptors) {
                result.addAll(desc.getResourceUris());
            }
        }
        return result;
    }
}

