/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions.terminals;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class BinaryValueConverter
extends AbstractLexerBasedConverter<Integer> {
    public static final String BINARY_PREFIX = "0b";

    public Integer toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to number.", node, null);
        }
        try {
            return Integer.parseInt(string.substring(2), 2);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to number.", node, null);
        }
    }

    protected String toEscapedString(Integer value) {
        if (value < 0) {
            return "-0b" + Integer.toString(value * -1, 2).toUpperCase();
        }
        return BINARY_PREFIX + Integer.toString(value, 2).toUpperCase();
    }
}

