/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.faulttolerance;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.faulttolerance.java.MicroProfileFaultToleranceErrorCode;
import org.junit.Test;

public class MicroProfileFaultToleranceJavaDiagnosticsTest
extends BasePropertiesManagerTest {
    @Test
    public void fallbackMethodsMissing() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/FaultTolerantResource.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d = MicroProfileForJavaAssert.d(14, 31, 36, "The referenced fallback method 'aaa' does not exist", DiagnosticSeverity.Error, "microprofile-faulttolerance", (IJavaErrorCode)MicroProfileFaultToleranceErrorCode.FALLBACK_METHOD_DOES_NOT_EXIST);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d);
    }

    @Test
    public void fallbackMethodValidationFaultTolerant() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/OtherFaultTolerantResource.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, new Diagnostic[0]);
    }
}

