/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Test;

public class DocumentEditAndUndoTest
extends AbstractTestWithProject {
    @Test
    public void testDocumentEditAndUndo() throws Exception {
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(new LinkedEditingRanges(List.of(new Range(new Position(0, 1), new Position(0, 2)), new Range(new Position(0, 5), new Position(0, 6))), "[:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\u10000-\\uEFFFF][:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\u10000-\\uEFFFF\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*"));
        String initialContent = "<a></a>";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "<a></a>");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        IDocument doc = viewer.getDocument();
        Assert.assertEquals((Object)"<a></a>", (Object)doc.get());
        Assert.assertTrue((boolean)LanguageServers.forDocument((IDocument)doc).anyMatching());
        final StyledText textWidget = viewer.getTextWidget();
        textWidget.setCaretOffset(2);
        TestUtils.waitForAndAssertCondition("Linked Editing not established", 3000, () -> Iterators.tryFind((Iterator)((ISourceViewer)viewer).getAnnotationModel().getAnnotationIterator(), anno -> anno.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")).isPresent());
        final Display display = textWidget.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                this.type((Control)textWidget, 'b');
                this.type((Control)textWidget, 'c');
            }

            private void type(Control control, char c) {
                control.forceFocus();
                Event keyEvent = new Event();
                keyEvent.widget = control;
                keyEvent.type = 1;
                keyEvent.character = c;
                keyEvent.keyCode = c;
                display.post(keyEvent);
                keyEvent.type = 2;
                display.post(keyEvent);
            }
        });
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Assert.assertEquals((String)"Document content isn't correctly changed", (Object)"<abc></abc>", (Object)doc.get());
            return true;
        });
        ITextOperationTarget textOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        BusyIndicator.showWhile((Display)display, () -> textOperationTarget.doOperation(1));
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Assert.assertEquals((String)"Document content isn't correctly reverted", (Object)"<a></a>", (Object)doc.get());
            return true;
        });
    }
}

