/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.swt.graphics.Color;

public class SemanticTokensTestUtil {
    public static final String keywordText = "type foo {\n\t\n}\ntype bar extends foo {\n\t\n}\n";
    public static final Color GREEN = new Color(133, 153, 0, 255);
    public static final Color RED = new Color(255, 0, 0);
    public static final IToken GREEN_TOKEN = new IToken(){

        public boolean isWhitespace() {
            return false;
        }

        public boolean isUndefined() {
            return false;
        }

        public boolean isOther() {
            return false;
        }

        public boolean isEOF() {
            return false;
        }

        public Object getData() {
            return new TextAttribute(GREEN);
        }
    };
    public static final IToken RED_TOKEN = new IToken(){

        public boolean isWhitespace() {
            return false;
        }

        public boolean isUndefined() {
            return false;
        }

        public boolean isOther() {
            return false;
        }

        public boolean isEOF() {
            return false;
        }

        public Object getData() {
            return new TextAttribute(RED);
        }
    };

    public static List<Integer> keywordSemanticTokens() {
        ArrayList<List<Integer>> expectedTokens = new ArrayList<List<Integer>>();
        expectedTokens.add(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0), Integer.valueOf(0)));
        expectedTokens.add(List.of(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(0), Integer.valueOf(0)));
        expectedTokens.add(List.of(Integer.valueOf(0), Integer.valueOf(9), Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(0)));
        return expectedTokens.stream().flatMap(Collection::stream).toList();
    }

    public static Function<String, IToken> keywordTokenTypeMapper(IToken token) {
        return t -> {
            if ("keyword".equals(t)) {
                return token;
            }
            return null;
        };
    }

    public static @NonNull Function<Position, Integer> offsetMapper(IDocument document) {
        return p -> {
            try {
                return LSPEclipseUtils.toOffset((Position)p, (IDocument)document);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void setSemanticTokensLegend(List<String> tokenTypes, List<String> tokenModifiers) {
        SemanticTokensLegend legend = new SemanticTokensLegend(tokenTypes, tokenModifiers);
        SemanticTokensWithRegistrationOptions semanticTokensWithRegistrationOptions = new SemanticTokensWithRegistrationOptions(legend);
        semanticTokensWithRegistrationOptions.setFull(Boolean.valueOf(true));
        semanticTokensWithRegistrationOptions.setRange(Boolean.valueOf(false));
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setSemanticTokensProvider(semanticTokensWithRegistrationOptions);
    }
}

