/**
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.formatting

import com.google.inject.Inject
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter
import org.eclipse.xtext.formatting.impl.FormattingConfig
import org.eclipse.lsat.setting.teditor.services.SettingGrammarAccess

/**
 * This class contains custom formatting description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#formatting
 * on how and when to use it 
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
class SettingFormatter extends AbstractDeclarativeFormatter {
	
	@Inject extension SettingGrammarAccess
	
	override protected configureFormatting(FormattingConfig c) {
        c.autoLinewrap = 120
		for(pair: findKeywordPairs('{', '}')) {
			c.setIndentation(pair.first, pair.second)
			c.setLinewrap(1).after(pair.first)
			c.setLinewrap(1).before(pair.second)
			c.setLinewrap(1).after(pair.second)
		}
        for(pair: findKeywordPairs('(', ')')) {
            c.setNoSpace().after(pair.first)
            c.setNoSpace().before(pair.second)
        }
        for(dot: findKeywords('.')) {
            c.setNoLinewrap().around(dot)
            c.setNoSpace().around(dot)
        }
        for(comma: findKeywords(',')) {
            c.setNoLinewrap().before(comma)
            c.setNoSpace().before(comma)
        }
        
        c.setLinewrap(1).after(importRule)
        
        c.setLinewrap(2, 2, 2).before(physicalSettingsRule)
        c.setLinewrap(2, 2, 2).after(physicalSettingsRule)

        c.setLinewrap(1).before(timingSettingsMapEntryRule)
        c.setLinewrap(1).before(profileSettingsMapEntryRule)
        c.setLinewrap(1).before(locationSettingsMapEntryRule)
        
		c.setLinewrap(0, 1, 2).before(SL_COMMENTRule)
		c.setLinewrap(0, 1, 2).before(ML_COMMENTRule)
		c.setLinewrap(0, 1, 1).after(ML_COMMENTRule)
	}
}
