/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.scheduler.algorithm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.lsat.common.emf.common.util.DiagnosticUtil;
import org.eclipse.lsat.common.emf.validation.EValidatorUtil;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.scheduler.algorithm.CompleteScheduledDependencies;
import org.eclipse.lsat.common.scheduler.algorithm.IScheduler;
import org.eclipse.lsat.common.scheduler.algorithm.SchedulerException;
import org.eclipse.lsat.common.scheduler.graph.Dependency;
import org.eclipse.lsat.common.scheduler.graph.GraphPackage;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.common.scheduler.resources.Resource;
import org.eclipse.lsat.common.scheduler.resources.ResourceModel;
import org.eclipse.lsat.common.scheduler.resources.util.ResourcesQueries;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduleFactory;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependency;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.scheduler.schedule.Sequence;
import org.slf4j.Logger;

public abstract class SchedulerBase<T extends Task>
implements IScheduler<T> {
    protected static final ScheduleFactory SCHEDULE_FACTORY = ScheduleFactory.eINSTANCE;
    private final Map<T, ScheduledTask<T>> itsTaskToScheduledTaskCache = new HashMap<T, ScheduledTask<T>>();
    private TaskDependencyGraph<? extends T> graph = null;
    private Schedule<T> schedule = null;

    public TaskDependencyGraph<? extends T> getGraph() {
        return this.graph;
    }

    public Schedule<T> getSchedule() {
        return this.schedule;
    }

    @Override
    public synchronized Schedule<T> createSchedule(TaskDependencyGraph<? extends T> taskDependencyGraph) throws SchedulerException {
        try {
            this.graph = taskDependencyGraph;
            this.validateGraph();
            this.schedule = this.initializeSchedule();
            this.performScheduling();
            this.postProcessSchedule();
            Schedule<T> schedule = this.schedule;
            return schedule;
        }
        finally {
            this.itsTaskToScheduledTaskCache.clear();
        }
    }

    protected abstract Logger getLog();

    protected void validateGraph() throws SchedulerException {
        EValidatorRegistryImpl validatorRegistry = new EValidatorRegistryImpl(EValidator.Registry.INSTANCE);
        EValidator[] eValidatorArray = this.getComplementaryGraphValidators();
        int n = eValidatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EValidator eValidator = eValidatorArray[n2];
            EValidatorUtil.registerValidations((EPackage)GraphPackage.eINSTANCE, (EValidator)eValidator, (EValidator.Registry)validatorRegistry);
            ++n2;
        }
        Diagnostician diagnostician = new Diagnostician((EValidator.Registry)validatorRegistry){

            public String getObjectLabel(EObject eObject) {
                if (eObject instanceof TaskDependencyGraph) {
                    String name = ((TaskDependencyGraph)eObject).getName();
                    return name == null ? "graph" : "graph " + name;
                }
                return super.getObjectLabel(eObject);
            }
        };
        Diagnostic diagnostic = diagnostician.validate(this.getGraph());
        switch (diagnostic.getSeverity()) {
            case 2: {
                this.getLog().warn(DiagnosticUtil.getFullMessage((Diagnostic)diagnostic));
                break;
            }
            case 4: {
                throw new SchedulerException((CharSequence)DiagnosticUtil.getFullMessage((Diagnostic)diagnostic));
            }
        }
    }

    protected EValidator[] getComplementaryGraphValidators() {
        return new EValidator[0];
    }

    protected Schedule<T> initializeSchedule() {
        Schedule schedule = SCHEDULE_FACTORY.createSchedule();
        schedule.setName(this.getGraph().getName());
        ResourceModel resourceModel = this.getGraph().getResourceModel();
        schedule.setResourceModel(resourceModel);
        Iterator i = ResourcesQueries.allResources((ResourceModel)resourceModel);
        while (i.hasNext()) {
            Sequence sequence = SCHEDULE_FACTORY.createSequence();
            sequence.setResource((Resource)i.next());
            sequence.setName(sequence.getResource().getName());
            schedule.getSequences().add((Object)sequence);
        }
        return schedule;
    }

    protected abstract void performScheduling() throws SchedulerException;

    protected void postProcessSchedule() {
        CompleteScheduledDependencies.perform(this.getSchedule());
    }

    protected Iterable<Sequence<T>> getSequences(Collection<Resource> resources) {
        return QueryableIterable.from((Iterable)this.getSchedule().getSequences()).select(sequence -> resources.contains(sequence.getResource()));
    }

    protected final ScheduledTask<T> createScheduledTask(T task, boolean createIncomingDependencies) {
        ScheduledTask target = SCHEDULE_FACTORY.createScheduledTask();
        target.setName(task.getName());
        target.setTask(task);
        target.setGraph(this.getSchedule());
        this.itsTaskToScheduledTaskCache.put(task, target);
        if (createIncomingDependencies) {
            for (Edge edge : task.getIncomingEdges()) {
                Task sourceT = (Task)edge.getSourceNode();
                ScheduledTask<Task> source = this.resolveScheduledTask(sourceT);
                ScheduledDependency dependency = SCHEDULE_FACTORY.createScheduledDependency();
                dependency.setSourceNode(source);
                dependency.setTargetNode((Node)target);
                dependency.setDependency((Dependency)edge);
                dependency.setGraph(this.getSchedule());
            }
        }
        return target;
    }

    protected final ScheduledTask<T> resolveScheduledTask(T task) {
        ScheduledTask<T> scheduledTask = this.itsTaskToScheduledTaskCache.get(task);
        if (scheduledTask == null) {
            throw new IllegalArgumentException("Task not found in schedule: " + task.getName());
        }
        return scheduledTask;
    }
}

