/*
 * Copyright (C) 2011 Wayne Meissner
 *
 * This file is part of the JNR project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jnr.ffi.provider;

import jnr.ffi.Pointer;

/**
 *
 */
public final class IntPointer extends InAccessibleMemoryIO {
    public IntPointer(jnr.ffi.Runtime runtime, long address) {
        super(runtime, address, true);
    }

    public IntPointer(jnr.ffi.Runtime runtime, int address) {
        super(runtime, address & 0xffffffffL, true);
    }

    public long size() {
        return 0;
    }

    @Override
    public int hashCode() {
        return (int) address();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Pointer && ((Pointer) obj).address() == address();
    }
}
