/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;

public class DockerConnectionManager {
    private static DockerConnectionManager instance;
    private static final int MAX_TIME = 40000;
    private List<IDockerConnection> connections;
    private ListenerList<IDockerConnectionManagerListener> connectionManagerListeners;
    Thread reloadThread = null;
    private IDockerConnectionSettingsFinder connectionSettingsFinder = new DefaultDockerConnectionSettingsFinder();
    private IDockerConnectionStorageManager connectionStorageManager = new DefaultDockerConnectionStorageManager();

    public static DockerConnectionManager getInstance() {
        if (instance == null) {
            instance = new DockerConnectionManager();
        }
        return instance;
    }

    private DockerConnectionManager() {
        this.reloadConnections();
    }

    public void reloadConnections() {
        this.reloadThread = new Thread(() -> {
            this.connections = this.connectionStorageManager.loadConnections();
            for (IDockerConnection connection : this.connections) {
                this.notifyListeners(connection, 0);
            }
            String runtimeDelegateProperty = "jakarta.ws.rs.ext.RuntimeDelegate";
            String originalRuntimeDelegate = System.setProperty("jakarta.ws.rs.ext.RuntimeDelegate", "org.glassfish.jersey.internal.RuntimeDelegateImpl");
            List<IDockerConnectionSettings> settings = this.connectionSettingsFinder.getKnownConnectionSettings();
            for (IDockerConnectionSettings setting : settings) {
                DockerConnection conn;
                if (setting == null) continue;
                if (setting.getType().equals((Object)IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION)) {
                    UnixSocketConnectionSettings usetting = (UnixSocketConnectionSettings)setting;
                    conn = new DockerConnection.Builder().name(usetting.getName()).unixSocketConnection(usetting);
                } else {
                    TCPConnectionSettings tsetting = (TCPConnectionSettings)setting;
                    conn = new DockerConnection.Builder().name(tsetting.getName()).tcpConnection(tsetting);
                }
                this.addConnectionUnchecked(conn, false);
            }
            if (originalRuntimeDelegate == null) {
                System.clearProperty("jakarta.ws.rs.ext.RuntimeDelegate");
            } else {
                System.setProperty("jakarta.ws.rs.ext.RuntimeDelegate", originalRuntimeDelegate);
            }
        });
        this.reloadThread.start();
    }

    public void setConnectionSettingsFinder(IDockerConnectionSettingsFinder connectionSettingsFinder) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        this.connectionSettingsFinder = connectionSettingsFinder;
    }

    public void setConnectionStorageManager(IDockerConnectionStorageManager connectionStorageManager) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        this.connectionStorageManager = connectionStorageManager;
    }

    public void saveConnections() {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        this.saveConnectionsUnchecked();
    }

    private void saveConnectionsUnchecked() {
        this.connectionStorageManager.saveConnections(this.connections);
    }

    public IDockerConnection[] getConnections() {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        if (this.connections == null) {
            return new IDockerConnection[0];
        }
        return this.connections.toArray(new IDockerConnection[this.connections.size()]);
    }

    public List<IDockerConnection> getAllConnections() {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        if (this.connections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.connections);
    }

    public IDockerConnection getFirstConnection() {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        if (!this.hasConnections()) {
            return null;
        }
        return this.connections.get(0);
    }

    public boolean hasConnections() {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        return this.connections != null && !this.connections.isEmpty();
    }

    public IDockerConnection getConnectionByName(String connectionName) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        return this.connections.stream().filter(connection -> connection.getName().equals(connectionName)).findFirst().orElse(null);
    }

    public IDockerConnection getConnectionByUri(String connectionUri) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join(40000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        return DockerConnectionManager.getInstance().getAllConnections().stream().filter(c -> c.getUri().equals(connectionUri)).findFirst().orElse(null);
    }

    public List<String> getConnectionNames() {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        return Collections.unmodifiableList(this.getAllConnections().stream().map(IDockerConnection::getName).filter(n -> n != null).toList());
    }

    public IDockerConnection findConnection(String name) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        if (name != null) {
            for (IDockerConnection connection : this.connections) {
                if (connection.getName() == null || !connection.getName().equals(name)) continue;
                return connection;
            }
        }
        return null;
    }

    public void addConnection(IDockerConnection dockerConnection) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        this.addConnection(dockerConnection, true);
    }

    public void addConnection(IDockerConnection dockerConnection, boolean notifyListeners) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        this.addConnectionUnchecked(dockerConnection, notifyListeners);
    }

    private void addConnectionUnchecked(IDockerConnection dockerConnection, boolean notifyListeners) {
        if (!this.connections.contains(dockerConnection)) {
            this.connections.add(dockerConnection);
            this.saveConnectionsUnchecked();
            if (notifyListeners) {
                this.notifyListeners(dockerConnection, 0);
            }
        }
    }

    public void removeConnection(IDockerConnection connection) {
        if (this.reloadThread != null) {
            try {
                this.reloadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reloadThread = null;
        }
        this.connections.remove(connection);
        this.saveConnections();
        this.notifyListeners(connection, 1);
        DockerContainerRefreshManager.getInstance().removeContainerRefreshThread(connection);
    }

    public void addConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners == null) {
            this.connectionManagerListeners = new ListenerList(1);
        }
        this.connectionManagerListeners.add((Object)listener);
    }

    public void removeConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners != null) {
            this.connectionManagerListeners.remove((Object)listener);
        }
    }

    public void notifyListeners(IDockerConnection connection, int type) {
        if (this.connectionManagerListeners != null) {
            for (IDockerConnectionManagerListener listener : this.connectionManagerListeners) {
                listener.changeEvent(connection, type);
            }
        }
    }

    public static void instanceNotifyListeners(IDockerConnection connection, int type) {
        if (instance != null) {
            instance.notifyListeners(connection, type);
        }
    }

    public IDockerConnectionSettings findDefaultConnectionSettings() {
        return this.connectionSettingsFinder.findDefaultConnectionSettings();
    }

    public String resolveConnectionName(IDockerConnectionSettings connectionSettings) {
        return this.connectionSettingsFinder.resolveConnectionName(connectionSettings);
    }

    public boolean updateConnection(IDockerConnection connection, String name, IDockerConnectionSettings connectionSettings) {
        boolean nameChanged = connection.setName(name);
        boolean settingsChanged = connection.setSettings(connectionSettings);
        if (nameChanged) {
            this.notifyListeners(connection, 2);
        }
        if (settingsChanged) {
            this.notifyListeners(connection, 3);
        }
        if (nameChanged || settingsChanged) {
            this.saveConnections();
            return true;
        }
        return false;
    }
}

