/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.junit.jupiter.api.Test;
import org.w3c.dom.CDATASection;

public class XMLCompletionExtensionTest
extends AbstractCacheBasedTest {
    private static final CompletionItem HELLO_WORLD_ITEM = XMLAssert.c("World", "World");

    @Test
    public void testSimpleCompletion() throws BadLocationException {
        XMLLanguageService service = new XMLLanguageService();
        service.registerCompletionParticipant((ICompletionParticipant)new TestCompletionParticipant());
        XMLAssert.testCompletionFor(service, "<hello>|</hello>", (String)null, null, null, null, true, HELLO_WORLD_ITEM);
    }

    @Test
    public void testCDATACompletion() throws BadLocationException {
        XMLLanguageService service = new XMLLanguageService();
        service.registerCompletionParticipant((ICompletionParticipant)new TestCompletionParticipant());
        XMLAssert.testCompletionFor(service, "<hello><![CDATA[ |]]></hello>", (String)null, null, null, null, true, HELLO_WORLD_ITEM);
        XMLAssert.testCompletionFor(service, "<hello><![CDATA[| ]]></hello>", (String)null, null, null, null, true, HELLO_WORLD_ITEM);
        XMLAssert.testCompletionFor(service, "<hello><![CDATA[ | ]]></hello>", (String)null, null, null, null, true, HELLO_WORLD_ITEM);
        XMLAssert.testCompletionFor(service, "<hello><![CDATA[|]]></hello>", (String)null, null, null, null, true, HELLO_WORLD_ITEM);
    }

    private final class TestCompletionParticipant
    implements ICompletionParticipant {
        private TestCompletionParticipant() {
        }

        public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
            if ("hello".equals(request.getCurrentTag())) {
                response.addCompletionAttribute(HELLO_WORLD_ITEM);
            } else {
                DOMElement element;
                String tagName;
                DOMNode node = request.getNode();
                if (node instanceof CDATASection && "hello".equals(tagName = (element = node.getParentElement()).getTagName())) {
                    response.addCompletionAttribute(HELLO_WORLD_ITEM);
                }
            }
        }

        public void onTagOpen(ICompletionRequest completionRequest, ICompletionResponse completionResponse, CancelChecker cancelChecker) throws Exception {
        }

        public void onDTDSystemId(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        }

        public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        }

        public void onAttributeName(boolean generateValue, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        }
    }
}

