/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolverRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.capabilities.CompletionResolveSupportProperty;
import org.eclipse.lsp4j.CompletionItem;

public class ResolveCompletionItemRequest
implements ICompletionItemResolverRequest {
    private final CompletionItem unresolved;
    private final String participantId;
    private final DOMDocument document;
    private final IComponentProvider componentProvider;
    private final SharedSettings sharedSettings;

    public ResolveCompletionItemRequest(CompletionItem unresolved, DOMDocument document, IComponentProvider componentProvider, SharedSettings sharedSettings) {
        this.unresolved = unresolved;
        this.participantId = DataEntryField.getParticipantId(unresolved.getData());
        this.document = document;
        this.componentProvider = componentProvider;
        this.sharedSettings = sharedSettings;
    }

    @Override
    public CompletionItem getUnresolved() {
        return this.unresolved;
    }

    @Override
    public String getParticipantId() {
        return this.participantId;
    }

    @Override
    public String getDataProperty(String fieldName) {
        return DataEntryField.getProperty(this.unresolved.getData(), fieldName);
    }

    @Override
    public boolean canSupportMarkupKind(String kind) {
        XMLCompletionSettings completionSettings = this.getSharedSettings().getCompletionSettings();
        return completionSettings.getCompletionCapabilities() != null && completionSettings.getCompletionCapabilities().getCompletionItem() != null && completionSettings.getCompletionCapabilities().getCompletionItem().getDocumentationFormat() != null && completionSettings.getCompletionCapabilities().getCompletionItem().getDocumentationFormat().contains(kind);
    }

    @Override
    public Integer getDataPropertyAsInt(String fieldName) {
        return DataEntryField.getPropertyAsInt(this.unresolved.getData(), fieldName);
    }

    @Override
    public Boolean getDataPropertyAsBoolean(String fieldName) {
        return DataEntryField.getPropertyAsBoolean(this.unresolved.getData(), fieldName);
    }

    @Override
    public <T> T getComponent(Class clazz) {
        return this.componentProvider.getComponent(clazz);
    }

    @Override
    public DOMDocument getDocument() {
        return this.document;
    }

    @Override
    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    @Override
    public boolean isResolveDocumentationSupported() {
        return this.getSharedSettings().getCompletionSettings().isCompletionResolveSupported(CompletionResolveSupportProperty.documentation);
    }

    @Override
    public boolean isResolveAdditionalTextEditsSupported() {
        return this.getSharedSettings().getCompletionSettings().isCompletionResolveSupported(CompletionResolveSupportProperty.additionalTextEdits);
    }

    @Override
    public Integer getCompletionOffset() {
        return this.getDataPropertyAsInt("offset");
    }
}

