/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.useradmin.BackendException;
import org.apache.felix.useradmin.RoleFactory;
import org.apache.felix.useradmin.RoleRepositoryStore;
import org.apache.felix.useradmin.impl.RoleChangeListener;
import org.apache.felix.useradmin.impl.role.ObservableRole;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.UserAdminPermission;

public final class RoleRepository {
    private static final Role USER_ANYONE = RoleFactory.createRole("user.anyone");
    private final RoleRepositoryStore m_store;
    private final CopyOnWriteArrayList m_listeners;
    private final RoleChangeReflector m_roleChangeReflector;

    public RoleRepository(RoleRepositoryStore store) {
        this.m_store = store;
        this.m_listeners = new CopyOnWriteArrayList();
        this.m_roleChangeReflector = new RoleChangeReflector();
    }

    public Role addRole(String name, int type) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        if (type != 2 && type != 1) {
            throw new IllegalArgumentException("Invalid role type!");
        }
        this.checkPermissions();
        try {
            Role result = this.m_store.addRole(name, type);
            if (result != null) {
                result = this.wireChangeListener(result);
                this.m_roleChangeReflector.roleAdded(result);
            }
            return result;
        }
        catch (Exception e) {
            throw new BackendException("Adding role " + name + " failed!", e);
        }
    }

    public void addRoleChangeListener(RoleChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RoleChangeListener cannot be null!");
        }
        this.m_listeners.addIfAbsent(listener);
    }

    public Role getRoleByName(String roleName) {
        try {
            Role result = this.isPredefinedRole(roleName) ? this.getPredefinedRole(roleName) : this.m_store.getRoleByName(roleName);
            return this.wireChangeListener(result);
        }
        catch (Exception e) {
            throw new BackendException("Failed to get role by name: " + roleName + "!", e);
        }
    }

    public List getRoles(String filter) {
        ArrayList<Role> matchingRoles = new ArrayList<Role>();
        try {
            Role[] roles = this.m_store.getRoles(this.sanitizeFilter(filter));
            for (int i = 0; i < roles.length; ++i) {
                Role role = roles[i];
                if (this.isPredefinedRole(role.getName())) continue;
                matchingRoles.add(this.wireChangeListener(role));
            }
        }
        catch (Exception e) {
            throw new BackendException("Failed to get roles!", e);
        }
        return matchingRoles;
    }

    public List getRoles(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        ArrayList<Role> matchingRoles = new ArrayList<Role>();
        try {
            String criteria = "(".concat(key).concat("=").concat(value).concat(")");
            Role[] roles = this.m_store.getRoles(criteria);
            for (int i = 0; i < roles.length; ++i) {
                Role role = roles[i];
                if (this.isPredefinedRole(role.getName())) continue;
                matchingRoles.add(this.wireChangeListener(role));
            }
        }
        catch (Exception e) {
            throw new BackendException("Failed to get roles!", e);
        }
        return matchingRoles;
    }

    public boolean removeRole(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        this.checkPermissions();
        if (this.isPredefinedRole(name)) {
            return false;
        }
        try {
            Role result = this.m_store.removeRole(name);
            if (result != null) {
                this.removeRoleFromAllGroups(result);
                this.unwireChangeListener(result);
                this.m_roleChangeReflector.roleRemoved(result);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new BackendException("Failed to remove role " + name + "!", e);
        }
    }

    public void removeRoleChangeListener(RoleChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RoleChangeListener cannot be null!");
        }
        this.m_listeners.remove(listener);
    }

    final Iterator createListenerIterator() {
        return this.m_listeners.iterator();
    }

    private void checkPermissions() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new UserAdminPermission("admin", null));
        }
    }

    private boolean isPredefinedRole(String roleName) {
        return "user.anyone".equals(roleName);
    }

    private Role getPredefinedRole(String roleName) {
        return USER_ANYONE;
    }

    private void removeRoleFromAllGroups(Role removedRole) {
        try {
            Role[] roles = this.m_store.getRoles(null);
            for (int i = 0; i < roles.length; ++i) {
                if (roles[i].getType() != 2) continue;
                Group group = (Group)roles[i];
                group.removeMember(removedRole);
            }
        }
        catch (Exception e) {
            throw new BackendException("Failed to get all roles!", e);
        }
    }

    private String sanitizeFilter(String filter) {
        if (filter == null || "".equals(filter.trim())) {
            return null;
        }
        return filter.trim();
    }

    private void unwireChangeListener(Object role) {
        if (role instanceof ObservableRole) {
            ((ObservableRole)role).setRoleChangeListener(null);
        }
    }

    private Role wireChangeListener(Role role) {
        ObservableRole result = ObservableRole.wrap(role);
        if (result instanceof ObservableRole) {
            result.setRoleChangeListener(this.m_roleChangeReflector);
        }
        return result;
    }

    final class RoleChangeReflector
    implements RoleChangeListener {
        RoleChangeReflector() {
        }

        @Override
        public void propertyAdded(Role role, Object key, Object value) {
            Iterator iterator = RoleRepository.this.createListenerIterator();
            while (iterator.hasNext()) {
                ((RoleChangeListener)iterator.next()).propertyAdded(role, key, value);
            }
        }

        @Override
        public void propertyChanged(Role role, Object key, Object oldValue, Object newValue) {
            Iterator iterator = RoleRepository.this.createListenerIterator();
            while (iterator.hasNext()) {
                ((RoleChangeListener)iterator.next()).propertyChanged(role, key, oldValue, newValue);
            }
        }

        @Override
        public void propertyRemoved(Role role, Object key) {
            Iterator iterator = RoleRepository.this.createListenerIterator();
            while (iterator.hasNext()) {
                ((RoleChangeListener)iterator.next()).propertyRemoved(role, key);
            }
        }

        @Override
        public void roleAdded(Role role) {
            Iterator iterator = RoleRepository.this.createListenerIterator();
            while (iterator.hasNext()) {
                ((RoleChangeListener)iterator.next()).roleAdded(role);
            }
        }

        @Override
        public void roleRemoved(Role role) {
            Iterator iterator = RoleRepository.this.createListenerIterator();
            while (iterator.hasNext()) {
                ((RoleChangeListener)iterator.next()).roleRemoved(role);
            }
        }
    }
}

