/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDevice;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattCharacteristic;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bluez.GattCharacteristic1;
import org.bluez.GattService1;
import org.bluez.exceptions.BluezNotImplementedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class BluetoothGattService
extends AbstractBluetoothObject {
    private final GattService1 service;
    private final BluetoothDevice device;
    private final Map<String, BluetoothGattCharacteristic> characteristicByUuid = new LinkedHashMap<String, BluetoothGattCharacteristic>();

    public BluetoothGattService(GattService1 _service, BluetoothDevice _device, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.GATT_SERVICE, _dbusConnection, _dbusPath);
        this.service = _service;
        this.device = _device;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return GattService1.class;
    }

    public void refreshGattCharacteristics() {
        this.characteristicByUuid.clear();
        Set<String> findNodes = DbusHelper.findNodes(this.getDbusConnection(), this.getDbusPath());
        Map<String, GattCharacteristic1> remoteObjects = this.getRemoteObjects(findNodes, this.getDbusPath(), GattCharacteristic1.class);
        for (Map.Entry<String, GattCharacteristic1> entry : remoteObjects.entrySet()) {
            BluetoothGattCharacteristic bluetoothGattCharacteristics = new BluetoothGattCharacteristic(entry.getValue(), this, entry.getKey(), this.getDbusConnection());
            this.characteristicByUuid.put(bluetoothGattCharacteristics.getUuid(), bluetoothGattCharacteristics);
        }
    }

    public List<BluetoothGattCharacteristic> getGattCharacteristics() {
        if (this.characteristicByUuid.isEmpty()) {
            this.refreshGattCharacteristics();
        }
        return new ArrayList<BluetoothGattCharacteristic>(this.characteristicByUuid.values());
    }

    public BluetoothGattCharacteristic getGattCharacteristicByUuid(String _uuid) {
        if (this.characteristicByUuid.isEmpty()) {
            this.refreshGattCharacteristics();
        }
        return this.characteristicByUuid.get(_uuid);
    }

    public String getUuid() {
        return this.getTyped("UUID", String.class);
    }

    public Boolean isPrimary() {
        return this.getTyped("Primary", Boolean.class);
    }

    public Object[] getIncludes() throws BluezNotImplementedException {
        throw new BluezNotImplementedException("Feature not yet implemented");
    }

    public GattService1 getService() {
        return this.service;
    }

    public BluetoothDevice getDevice() {
        return this.device;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [service=" + this.service + ", device=" + this.device.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

