/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.api;

import de.taimos.gpsd4java.api.ObjectListener;
import de.taimos.gpsd4java.backend.GISTool;
import de.taimos.gpsd4java.types.TPVObject;

public abstract class DistanceListener
extends ObjectListener {
    private TPVObject lastPosition;
    private final double threshold;

    public DistanceListener(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void handleTPV(TPVObject tpv) {
        if (this.lastPosition == null || GISTool.getDistance(tpv, this.lastPosition) > this.threshold) {
            this.lastPosition = tpv;
            this.handleLocation(tpv);
        }
    }

    protected abstract void handleLocation(TPVObject var1);
}

