/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPAnswer;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPSessionThread;

class PMPOutputStream
extends OutputStream {
    private PMPSessionThread c;
    protected Map answers = new Hashtable();
    private static IOException ioExc;
    private boolean closed = false;
    protected byte[] buffer;
    private short position;
    private OutputStream os;
    private short dataOffset;
    private short clientMsgID = (short)100;
    private short msgID;
    private boolean locked = false;
    private int waiting = 0;
    protected boolean ping = false;
    protected long time = System.currentTimeMillis();

    public PMPOutputStream(OutputStream os, PMPSessionThread c) {
        this.os = os;
        this.c = c;
        this.buffer = new byte[4096];
        this.dataOffset = (short)5;
    }

    public void write(int b) throws IOException {
        if (this.position == this.buffer.length) {
            this.flush(false);
        }
        short s = this.position;
        this.position = (short)(s + 1);
        this.buffer[s] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int more = this.position + len - this.buffer.length;
        if (more > 0) {
            System.arraycopy(b, off, this.buffer, this.position, len - more);
            this.position = (short)this.buffer.length;
            this.flush(false);
            this.write(b, off + len - more, more);
        } else {
            System.arraycopy(b, off, this.buffer, this.position, len);
            this.position = (short)(this.position + len);
        }
    }

    public void write(InputStream is) throws IOException {
        while (true) {
            int toWrite;
            int free;
            if ((free = this.buffer.length - this.position) < 10) {
                this.flush(false);
                free = this.buffer.length - this.position;
            }
            if ((toWrite = is.read(this.buffer, this.position + 2, free - 2)) == -1) break;
            this.writeShort((short)toWrite, this.buffer, this.position);
            this.position = (short)(this.position + (toWrite + 2));
            if (this.position != this.buffer.length) continue;
            this.flush(false);
        }
        this.writeShort((short)-1, this.buffer, this.position);
        this.position = (short)(this.position + 2);
    }

    private void writeShort(short s, byte[] b, int off) {
        b[off++] = (byte)(s >>> 8 & 0xFF);
        b[off] = (byte)(s & 0xFF);
    }

    public void flush() throws IOException {
        this.flush(false);
    }

    private void flush(boolean last) throws IOException {
        if (this.closed) {
            throw new IOException("Disconnected");
        }
        if (last) {
            this.buffer[this.dataOffset - 1] = 1;
            this.writeBuffer();
        } else {
            this.buffer[this.dataOffset - 1] = 0;
            this.writeBuffer();
            this.position = this.dataOffset;
            this.writeShort(this.msgID, this.buffer, 0);
        }
    }

    private void writeBuffer() throws IOException {
        this.writeShort((short)(this.position - this.dataOffset), this.buffer, 2);
        this.os.write(this.buffer, 0, this.position);
        this.os.flush();
    }

    public synchronized void begin(short msgID) {
        while (this.locked) {
            ++this.waiting;
            try {
                this.wait();
            }
            catch (Exception exception) {}
            --this.waiting;
        }
        if (this.closed) {
            return;
        }
        this.msgID = msgID;
        this.locked = true;
        this.position = this.dataOffset;
        this.writeShort(this.msgID, this.buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected synchronized short begin(PMPAnswer answer) {
        if (!this.closed) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            ++this.waiting;
            try {
                this.wait();
            }
            catch (Exception v0) {}
            --this.waiting;
lbl9:
            // 2 sources

            ** while (this.locked)
        }
lbl10:
        // 1 sources

        if (this.closed) {
            return -1;
        }
        this.locked = true;
        this.clientMsgID = (short)(this.clientMsgID + 1);
        if (this.clientMsgID <= 0) {
            this.clientMsgID = 1;
        }
        this.msgID = this.clientMsgID;
        try {
            this.writeShort(this.msgID, this.buffer, 0);
        }
        catch (Exception v1) {}
        this.position = this.dataOffset;
        if (answer != null) {
            var2_2 = this.answers;
            synchronized (var2_2) {
                this.answers.put(new Short(this.msgID), answer);
            }
        }
        return this.msgID;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void end(boolean checkClosed) throws IOException {
        block5: {
            block6: {
                try {
                    try {
                        this.flush(true);
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.unlock();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                    this.unlock();
                    if (!checkClosed || !this.closed) break block5;
                    if (ioExc != null) break block6;
                    ioExc = new IOException("Disconnected");
                }
            }
            throw ioExc;
        }
    }

    protected synchronized void unlock() {
        this.locked = false;
        if (this.waiting > 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.os.close();
        }
        catch (Exception exception) {}
        try {
            Map map = this.answers;
            synchronized (map) {
                this.closed = true;
                Iterator it = this.answers.values().iterator();
                while (it.hasNext()) {
                    PMPAnswer tmp = (PMPAnswer)it.next();
                    tmp.errMsg = "Connection is closed";
                    tmp.finish();
                    Object var3_3 = null;
                }
                this.answers.clear();
            }
            this.unlock();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkWaitStatus(String msg) {
        if (this.ping) {
            this.c.disconnect(msg, false);
        }
        Map map = this.answers;
        synchronized (map) {
            Iterator it = this.answers.values().iterator();
            while (it.hasNext()) {
                PMPAnswer answer = (PMPAnswer)it.next();
                if (!answer.waiting) continue;
                try {
                    answer.errMsg = "Connection is closing: " + msg;
                    answer.finish();
                    this.closed = true;
                    this.c.disconnect(msg, false);
                    return;
                }
                catch (Exception exception) {}
            }
        }
        this.unlock();
        this.ping = true;
        try {
            this.c.ping();
        }
        catch (Exception exc) {
            this.c.disconnect(exc.getMessage(), false);
        }
    }
}

