/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.identity.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.internal.rest.identity.provider.dto.UserDTO;
import org.eclipse.kura.util.useradmin.UserAdminHelper;
import org.eclipse.kura.util.validation.PasswordStrengthValidators;
import org.eclipse.kura.util.validation.Validator;
import org.eclipse.kura.util.validation.ValidatorOptions;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class IdentityService {
    private static final String IDENTITY = "Identity ";
    private static final String KURA_WEB_CONSOLE_SERVICE_PID = "org.eclipse.kura.web.Console";
    private static final String PERMISSION_ROLE_NAME_PREFIX = "kura.permission.";
    private static final String USER_ROLE_NAME_PREFIX = "kura.user.";
    private static final String KURA_NEED_PASSWORD_CHANGE_PROPERTY = "kura.need.password.change";
    private static final String PASSWORD_PROPERTY = "kura.password";
    private final UserAdminHelper userAdminHelper;
    private final ConfigurationService configurationService;
    private final CryptoService cryptoService;

    public IdentityService(CryptoService cryptoService, UserAdmin userAdmin, ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.cryptoService = cryptoService;
        this.userAdminHelper = new UserAdminHelper(userAdmin, cryptoService);
    }

    public void createUser(UserDTO user) throws KuraException {
        if (!this.userAdminHelper.getUser(user.getUserName()).isPresent()) {
            String password = user.getPassword();
            if (password != null) {
                this.validateUserPassword(password);
            }
        } else {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{IDENTITY + user.getUserName() + " already exists"});
        }
        this.userAdminHelper.createUser(user.getUserName());
        this.updateUser(user);
    }

    public void deleteUser(String userName) {
        this.userAdminHelper.deleteUser(userName);
    }

    public UserDTO getUser(String userName) throws KuraException {
        Optional user = this.userAdminHelper.getUser(userName);
        if (user.isPresent()) {
            UserDTO userFound = this.initUserConfig((User)user.get());
            this.fillPermissions(Collections.singletonMap(((User)user.get()).getName(), userFound));
            return userFound;
        }
        throw new KuraException(KuraErrorCode.NOT_FOUND, new Object[]{IDENTITY + userName + " not found"});
    }

    public Set<String> getDefinedPermissions() {
        return this.userAdminHelper.getDefinedPermissions();
    }

    public Set<UserDTO> getUserConfig() {
        HashMap result = new HashMap();
        this.userAdminHelper.foreachUser((name, user) -> {
            UserDTO userData = this.initUserConfig(user);
            result.put(user.getName(), userData);
        });
        this.fillPermissions(result);
        return new HashSet<UserDTO>(result.values());
    }

    private UserDTO initUserConfig(User user) {
        boolean isPasswordEnabled = user.getCredentials().get(PASSWORD_PROPERTY) instanceof String;
        boolean isPasswordChangeRequired = Objects.equals("true", user.getProperties().get(KURA_NEED_PASSWORD_CHANGE_PROPERTY));
        return new UserDTO(IdentityService.getBaseName((Role)user), new HashSet<String>(), isPasswordEnabled, isPasswordChangeRequired);
    }

    private static boolean isKuraUser(Role role) {
        return role.getName().startsWith(USER_ROLE_NAME_PREFIX);
    }

    private static boolean isKuraPermission(Role role) {
        return role.getName().startsWith(PERMISSION_ROLE_NAME_PREFIX);
    }

    private static String getBaseName(Role role) {
        String name = role.getName();
        if (IdentityService.isKuraUser(role)) {
            return name.substring(USER_ROLE_NAME_PREFIX.length());
        }
        if (IdentityService.isKuraPermission(role)) {
            return name.substring(PERMISSION_ROLE_NAME_PREFIX.length());
        }
        throw new IllegalArgumentException("not a Kura role");
    }

    private void fillPermissions(Map<String, ? extends UserDTO> userData) {
        this.userAdminHelper.foreachPermission((permission, group) -> IdentityService.forEach(group.getMembers(), member -> {
            UserDTO data = (UserDTO)userData.get(member.getName());
            if (data != null) {
                data.getPermissions().add(permission);
            }
        }));
    }

    private static <T, E extends Exception> void forEach(T[] items, UserAdminHelper.FallibleConsumer<T, E> consumer) throws E {
        if (items != null) {
            T[] TArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                T item = TArray[n2];
                consumer.accept(item);
                ++n2;
            }
        }
    }

    public void updateUser(UserDTO userDTOToUpdate) throws KuraException {
        Optional user = this.userAdminHelper.getUser(userDTOToUpdate.getUserName());
        if (user.isPresent()) {
            Set<String> permissions = userDTOToUpdate.getPermissions();
            if (permissions != null) {
                this.userAdminHelper.foreachPermission((permissionName, permissionGroup) -> {
                    if (permissions.contains(permissionName)) {
                        permissionGroup.addMember((Role)user.get());
                    } else {
                        permissionGroup.removeMember((Role)user.get());
                    }
                });
            }
        } else {
            throw new KuraException(KuraErrorCode.NOT_FOUND, new Object[]{IDENTITY + userDTOToUpdate.getUserName() + " not found"});
        }
        this.updatePasswordOptions(userDTOToUpdate, ((User)user.get()).getCredentials(), ((User)user.get()).getProperties());
    }

    private void updatePasswordOptions(UserDTO userDTO, Dictionary<String, Object> credentials, Dictionary<String, Object> properties) throws KuraException {
        Optional<Boolean> isPasswordChangeNeededParam;
        Optional<Boolean> isPasswordAuthEnabledParam = userDTO.isPasswordAuthEnabled();
        if (isPasswordAuthEnabledParam.isPresent()) {
            if (Boolean.TRUE.equals(isPasswordAuthEnabledParam.get())) {
                String password = userDTO.getPassword();
                if (password != null) {
                    this.validateUserPassword(password);
                    try {
                        credentials.put(PASSWORD_PROPERTY, this.cryptoService.sha256Hash(password));
                    }
                    catch (Exception e) {
                        throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, (Throwable)e, new Object[0]);
                    }
                }
            } else {
                credentials.remove(PASSWORD_PROPERTY);
            }
        }
        if ((isPasswordChangeNeededParam = userDTO.isPasswordChangeNeeded()).isPresent()) {
            if (Boolean.TRUE.equals(isPasswordChangeNeededParam.get())) {
                properties.put(KURA_NEED_PASSWORD_CHANGE_PROPERTY, "true");
            } else {
                properties.remove(KURA_NEED_PASSWORD_CHANGE_PROPERTY);
            }
        }
    }

    public void validateUserPassword(String password) throws KuraException {
        ValidatorOptions validatorOptions = this.getValidatorOptions();
        List validators = PasswordStrengthValidators.fromConfig((ValidatorOptions)validatorOptions);
        ArrayList errors = new ArrayList();
        for (Validator validator : validators) {
            validator.validate((Object)password, errors::add);
        }
        if (!errors.isEmpty()) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"password strenght requirements not satisfied", errors});
        }
    }

    public ValidatorOptions getValidatorOptions() throws KuraException {
        ComponentConfiguration consoleConfig = this.configurationService.getComponentConfiguration(KURA_WEB_CONSOLE_SERVICE_PID);
        return new ValidatorOptions(consoleConfig.getConfigurationProperties());
    }
}

