/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthenticationProviderHolder
implements Comparable<AuthenticationProviderHolder>,
AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationProviderHolder.class);
    private final int priority;
    private final AuthenticationProvider wrapped;

    public AuthenticationProviderHolder(AuthenticationProvider provider) {
        this.priority = AuthenticationProviderHolder.getPriority(provider.getClass());
        this.wrapped = provider;
    }

    private static int getPriority(Class<?> classz) {
        if (classz == Object.class) {
            return Integer.MAX_VALUE;
        }
        Priority priorityAnnotation = classz.getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            return priorityAnnotation.value();
        }
        return AuthenticationProviderHolder.getPriority(classz.getSuperclass());
    }

    @Override
    public Optional<Principal> authenticate(HttpServletRequest request, ContainerRequestContext requestContext) {
        try {
            return this.wrapped.authenticate(request, requestContext);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception calling authentication provider", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void onEnabled() {
        try {
            this.wrapped.onEnabled();
        }
        catch (Exception e) {
            logger.warn("Unexpected exception enabling authentication provider", (Throwable)e);
        }
    }

    @Override
    public void onDisabled() {
        try {
            this.wrapped.onDisabled();
        }
        catch (Exception e) {
            logger.warn("Unexpected exception disabling authentication provider", (Throwable)e);
        }
    }

    @Override
    public int compareTo(AuthenticationProviderHolder other) {
        return Integer.compare(this.priority, other.priority);
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.wrapped);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthenticationProviderHolder)) {
            return false;
        }
        AuthenticationProviderHolder other = (AuthenticationProviderHolder)obj;
        return this.priority == other.priority && Objects.equals(this.wrapped, other.wrapped);
    }
}

