/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.service;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import java.util.List;
import org.eclipse.kura.web.server.Audit;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtFirewallNatEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallOpenPortEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallPortForwardEntry;
import org.eclipse.kura.web.shared.model.GwtModemPdpEntry;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiChannelFrequency;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;

@RemoteServiceRelativePath(value="network")
@RequiredPermissions(value={"kura.network.admin"})
public interface GwtNetworkService
extends RemoteService {
    public List<GwtNetInterfaceConfig> findNetInterfaceConfigurations(boolean var1) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Update network interface configurations")
    public void updateNetInterfaceConfigurations(GwtXSRFToken var1, GwtNetInterfaceConfig var2) throws GwtKuraException;

    public List<GwtFirewallOpenPortEntry> findDeviceFirewallOpenPorts(GwtXSRFToken var1) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Update firewall open ports")
    public void updateDeviceFirewallOpenPorts(GwtXSRFToken var1, List<GwtFirewallOpenPortEntry> var2) throws GwtKuraException;

    public List<GwtFirewallPortForwardEntry> findDeviceFirewallPortForwards(GwtXSRFToken var1) throws GwtKuraException;

    public List<GwtFirewallNatEntry> findDeviceFirewallNATs(GwtXSRFToken var1) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Update firewall open ports")
    public void updateDeviceFirewallPortForwards(GwtXSRFToken var1, List<GwtFirewallPortForwardEntry> var2) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Update firewall NAT configuration")
    public void updateDeviceFirewallNATs(GwtXSRFToken var1, List<GwtFirewallNatEntry> var2) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Renew DHCP lease")
    public void renewDhcpLease(GwtXSRFToken var1, String var2) throws GwtKuraException;

    @Audit(componentName="UI Network", description="WiFi scan")
    public List<GwtWifiHotspotEntry> findWifiHotspots(GwtXSRFToken var1, String var2, String var3) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Get Wifi channels and frequencies")
    public List<GwtWifiChannelFrequency> findFrequencies(GwtXSRFToken var1, String var2, GwtWifiRadioMode var3) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Get Wifi Country Code")
    public String getWifiCountryCode(GwtXSRFToken var1) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Verify Wifi credentials")
    public boolean verifyWifiCredentials(GwtXSRFToken var1, String var2, GwtWifiConfig var3) throws GwtKuraException;

    @Audit(componentName="UI Network", description="Detect if using Network Manager or legacy networking implementation")
    public boolean isNet2();

    public List<GwtModemPdpEntry> findPdpContextInfo(GwtXSRFToken var1, String var2) throws GwtKuraException;

    public boolean isIEEE80211ACSupported(GwtXSRFToken var1, String var2) throws GwtKuraException;

    public List<String> getDhcpLeases(GwtXSRFToken var1) throws GwtKuraException;
}

