/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.request.handler.jaxrs;

import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.RequestParameterHandlers;
import org.eclipse.kura.request.handler.jaxrs.ResponseBodyHandlers;
import org.eclipse.kura.request.handler.jaxrs.annotation.EXEC;
import org.eclipse.kura.request.handler.jaxrs.consumer.RequestParameterHandler;
import org.eclipse.kura.request.handler.jaxrs.consumer.ResponseBodyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsRequestHandlerProxy
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(JaxRsRequestHandlerProxy.class);
    private final Object target;
    private final Map<Endpoint, MethodProxy> endpoints;
    private final Gson gson = this.buildGson();

    public JaxRsRequestHandlerProxy(Object target) {
        this.target = target;
        this.endpoints = this.probeRequestMethods(target);
    }

    public KuraMessage doGet(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        return this.dispatch(RequestHandlerMethod.GET, reqMessage);
    }

    public KuraMessage doPost(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        return this.dispatch(RequestHandlerMethod.POST, reqMessage);
    }

    public KuraMessage doPut(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        return this.dispatch(RequestHandlerMethod.PUT, reqMessage);
    }

    public KuraMessage doExec(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        return this.dispatch(RequestHandlerMethod.EXEC, reqMessage);
    }

    public KuraMessage doDel(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        return this.dispatch(RequestHandlerMethod.DELETE, reqMessage);
    }

    protected Gson buildGson() {
        return new Gson();
    }

    protected Map<Endpoint, MethodProxy> probeRequestMethods(Object object) {
        Method[] methods;
        HashMap<Endpoint, MethodProxy> result = new HashMap<Endpoint, MethodProxy>();
        Method[] methodArray = methods = object.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Optional<Endpoint> endpoint = this.probeEndpoint(method);
            if (endpoint.isPresent()) {
                this.buildMethodProxy(method).ifPresent(s -> {
                    MethodProxy methodProxy = result.put((Endpoint)endpoint.get(), (MethodProxy)s);
                });
            }
            ++n2;
        }
        return result;
    }

    protected String resourcesToPath(List<String> resources) {
        return "/" + resources.stream().collect(Collectors.joining("/"));
    }

    protected Optional<Endpoint> probeEndpoint(Method method) {
        RequestHandlerMethod requestHandlerMethod;
        Path path = method.getAnnotation(Path.class);
        if (path == null) {
            logger.debug("{} does not specify the Path annotation, ignoring", (Object)method);
            return Optional.empty();
        }
        if (method.isAnnotationPresent(EXEC.class)) {
            logger.debug("found EXEC method: {}", (Object)method);
            requestHandlerMethod = RequestHandlerMethod.EXEC;
        } else if (method.isAnnotationPresent(GET.class)) {
            logger.debug("found GET method: {}", (Object)method);
            requestHandlerMethod = RequestHandlerMethod.GET;
        } else if (method.isAnnotationPresent(POST.class)) {
            logger.debug("found POST method: {}", (Object)method);
            requestHandlerMethod = RequestHandlerMethod.POST;
        } else if (method.isAnnotationPresent(PUT.class)) {
            logger.debug("found PUT method: {}", (Object)method);
            requestHandlerMethod = RequestHandlerMethod.PUT;
        } else if (method.isAnnotationPresent(DELETE.class)) {
            logger.debug("found DELETE method: {}", (Object)method);
            requestHandlerMethod = RequestHandlerMethod.DELETE;
        } else {
            logger.debug("{} is not a supported REST method, ignoring", (Object)method);
            return Optional.empty();
        }
        logger.debug("found method {}, path: {}, rest method: {}", new Object[]{method, path, requestHandlerMethod});
        return Optional.of(new Endpoint(requestHandlerMethod, path.value()));
    }

    protected Optional<MethodProxy> buildMethodProxy(Method method) {
        RequestParameterHandler parameterHandler;
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            parameterHandler = RequestParameterHandlers.noArgsHandler();
        } else if (parameters.length == 1) {
            Parameter parameter = parameters[0];
            Class<?> type = parameter.getType();
            parameterHandler = type == InputStream.class ? RequestParameterHandlers.inputStreamHandler() : RequestParameterHandlers.gsonHandler(type, this.gson);
        } else {
            logger.debug("method {} has more than one parameter, ignoring", (Object)method);
            return Optional.empty();
        }
        Class<?> returnType = method.getReturnType();
        ResponseBodyHandler bodyHandler = returnType == Void.class ? ResponseBodyHandlers.voidHandler() : (returnType == Response.class ? ResponseBodyHandlers.responseHandler(this.gson) : ResponseBodyHandlers.gsonHandler(this.gson));
        return Optional.of(new MethodProxy(method, parameterHandler, bodyHandler));
    }

    protected KuraMessage dispatch(RequestHandlerMethod restMethod, KuraMessage request) {
        try {
            List<String> resources = JaxRsRequestHandlerProxy.extractResources(request);
            String path = this.resourcesToPath(resources);
            MethodProxy proxy = Optional.ofNullable(this.endpoints.get(new Endpoint(restMethod, path))).orElseThrow(() -> new KuraException(KuraErrorCode.NOT_FOUND));
            return this.invoke(proxy, this.target, request);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    protected KuraMessage invoke(MethodProxy proxy, Object target, KuraMessage request) throws KuraException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] parameters = proxy.parameterHandler.buildParameters(request);
        Object result = proxy.method.invoke(target, parameters);
        KuraResponsePayload resultPayload = new KuraResponsePayload(200);
        proxy.bodyHandler.buildBody(result).ifPresent(arg_0 -> ((KuraPayload)resultPayload).setBody(arg_0));
        return new KuraMessage((KuraPayload)resultPayload);
    }

    protected KuraMessage handleException(Throwable e) {
        return DefaultExceptionHandler.toKuraMessage(DefaultExceptionHandler.toWebApplicationException(e), Optional.of(this.gson));
    }

    private static List<String> extractResources(KuraMessage request) throws KuraException {
        try {
            return Objects.requireNonNull((List)request.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value()));
        }
        catch (Exception exception) {
            logger.warn("failed to get resources from request");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
    }

    public static class Endpoint {
        private final RequestHandlerMethod method;
        private final String relativePath;

        public Endpoint(RequestHandlerMethod method, String relativePath) {
            this.method = method;
            this.relativePath = relativePath;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.method, this.relativePath});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            return this.method == other.method && Objects.equals(this.relativePath, other.relativePath);
        }
    }

    public static class MethodProxy {
        private Method method;
        private RequestParameterHandler parameterHandler;
        private ResponseBodyHandler bodyHandler;

        public MethodProxy(Method method, RequestParameterHandler parameterHandler, ResponseBodyHandler bodyHandler) {
            this.method = method;
            this.parameterHandler = parameterHandler;
            this.bodyHandler = bodyHandler;
        }
    }

    public static enum RequestHandlerMethod {
        GET,
        POST,
        PUT,
        DELETE,
        EXEC;

    }
}

