/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.security;

import io.moquette.spi.impl.security.AuthorizationsCollector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(ACLFileParser.class);

    public static AuthorizationsCollector parse(File file) throws ParseException {
        if (file == null) {
            LOG.warn("parsing NULL file, so fallback on default configuration!");
            return AuthorizationsCollector.emptyImmutableCollector();
        }
        if (!file.exists()) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()));
            return AuthorizationsCollector.emptyImmutableCollector();
        }
        try {
            FileReader reader = new FileReader(file);
            return ACLFileParser.parse(reader);
        }
        catch (FileNotFoundException fex) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()), fex);
            return AuthorizationsCollector.emptyImmutableCollector();
        }
    }

    public static AuthorizationsCollector parse(Reader reader) throws ParseException {
        if (reader == null) {
            LOG.warn("parsing NULL reader, so fallback on default configuration!");
            return AuthorizationsCollector.emptyImmutableCollector();
        }
        BufferedReader br = new BufferedReader(reader);
        AuthorizationsCollector collector = new AuthorizationsCollector();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int commentMarker = line.indexOf(35);
                if (commentMarker != -1) {
                    if (commentMarker == 0) continue;
                    throw new ParseException(line, commentMarker);
                }
                if (line.isEmpty() || line.matches("^\\s*$")) continue;
                collector.parse(line);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
        return collector;
    }
}

