/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.kura.web.shared.model.GwtBaseModel;

public class GwtUserData
extends GwtBaseModel
implements Serializable {
    private static final long serialVersionUID = -1334340006399833329L;
    private static final int MAX_TEXT_LENGTH = 22;
    private HashSet<String> unused;

    public GwtUserData() {
    }

    public GwtUserData(String userName, Set<String> permissions) {
        this.setUserName(userName);
        this.setPermissions(permissions);
    }

    public void setUserName(String userName) {
        this.set("userName", userName);
    }

    public void setPermissions(Set<String> permissions) {
        this.set("permissions", new HashSet<String>(permissions));
    }

    public String getUserName() {
        return (String)this.get("userName");
    }

    public String getUserNameEllipsed() {
        String username = (String)this.get("userName");
        if (username.length() > 22) {
            return String.valueOf(username.substring(0, 22)) + "...";
        }
        return username;
    }

    public Set<String> getPermissions() {
        return (Set)this.get("permissions");
    }

    public boolean isAdmin() {
        return this.getPermissions().contains("kura.admin");
    }

    public boolean checkPermissions(Set<String> permissions) {
        if (this.isAdmin()) {
            return true;
        }
        return this.getPermissions().containsAll(permissions);
    }

    public boolean checkPermission(String permission) {
        if (this.isAdmin()) {
            return true;
        }
        return this.getPermissions().contains(permission);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isAdmin() ? 1231 : 1237);
        result = 31 * result + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        result = 31 * result + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GwtUserData other = (GwtUserData)obj;
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        if (this.getPermissions() == null ? other.getPermissions() != null : !this.getPermissions().equals(other.getPermissions())) {
            return false;
        }
        return !(this.getUserName() == null ? other.getUserName() != null : !this.getUserName().equals(other.getUserName()));
    }
}

