/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnection.raw.mqtt.subscriber;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.raw.mqtt.cloud.RawMqttCloudEndpoint;
import org.eclipse.kura.cloudconnection.raw.mqtt.subscriber.SubscribeOptions;
import org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber;
import org.eclipse.kura.cloudconnection.subscriber.listener.CloudSubscriberListener;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.AbstractStackComponent;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.StackComponentOptions;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMqttSubscriber
extends AbstractStackComponent<SubscribeOptions>
implements CloudSubscriber,
CloudSubscriberListener {
    private static final Logger logger = LoggerFactory.getLogger(RawMqttSubscriber.class);
    private final Set<CloudSubscriberListener> cloudSubscriberListeners = new CopyOnWriteArraySet<CloudSubscriberListener>();

    @Override
    protected void setCloudEndpoint(RawMqttCloudEndpoint endpoint) {
        super.setCloudEndpoint(endpoint);
        this.trySubscribe();
    }

    @Override
    protected void unsetCloudEndpoint(RawMqttCloudEndpoint endpoint) {
        this.tryUnsubscribe();
        super.unsetCloudEndpoint(endpoint);
    }

    public void registerCloudSubscriberListener(CloudSubscriberListener listener) {
        this.cloudSubscriberListeners.add(listener);
    }

    public void unregisterCloudSubscriberListener(CloudSubscriberListener listener) {
        this.cloudSubscriberListeners.remove(listener);
    }

    public void onMessageArrived(KuraMessage message) {
        this.cloudSubscriberListeners.forEach(Utils.catchAll(l -> l.onMessageArrived(message)));
    }

    private void trySubscribe() {
        Optional<RawMqttCloudEndpoint> endpoint = this.getEndpoint();
        if (!endpoint.isPresent()) {
            return;
        }
        RawMqttCloudEndpoint currentEndpoint = endpoint.get();
        currentEndpoint.unregisterSubscriber(this);
        StackComponentOptions options = this.getOptions();
        Optional subscribeOptions = options.getComponentOptions();
        if (subscribeOptions.isPresent()) {
            currentEndpoint.registerSubscriber((SubscribeOptions)subscribeOptions.get(), (CloudSubscriberListener)this);
        }
    }

    private void tryUnsubscribe() {
        Optional<RawMqttCloudEndpoint> endpoint = this.getEndpoint();
        if (endpoint.isPresent()) {
            endpoint.get().unregisterSubscriber(this);
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected StackComponentOptions.OptionsFactory<SubscribeOptions> getOptionsFactory() {
        return SubscribeOptions::new;
    }
}

