/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.comm;

import java.net.URISyntaxException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CommURI {
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_SPACE = 4;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_1_5 = 3;
    public static final int STOPBITS_2 = 2;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    private final String port;
    private final int baudRate;
    private final int dataBits;
    private final int stopBits;
    private final int parity;
    private final int flowControl;
    private final int openTimeout;
    private final int receiveTimeout;

    private CommURI(Builder builder) {
        this.port = builder.builderPort;
        this.baudRate = builder.builderBaudRate;
        this.dataBits = builder.builderDdataBits;
        this.stopBits = builder.builderStopBits;
        this.parity = builder.builderParity;
        this.flowControl = builder.builderFlowControl;
        this.openTimeout = builder.builderOpenTimeout;
        this.receiveTimeout = builder.builderReceiveTimeout;
    }

    public String getPort() {
        return this.port;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public int getFlowControl() {
        return this.flowControl;
    }

    @Deprecated
    public int getTimeout() {
        return this.openTimeout;
    }

    public int getOpenTimeout() {
        return this.openTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("comm:").append(this.port).append(";baudrate=").append(this.baudRate).append(";databits=").append(this.dataBits).append(";stopbits=").append(this.stopBits).append(";parity=").append(this.parity).append(";flowcontrol=").append(this.flowControl).append(";timeout=").append(this.openTimeout).append(";receivetimeout=").append(this.receiveTimeout);
        return sb.toString();
    }

    public static CommURI parseString(String uri) throws URISyntaxException {
        if (!uri.startsWith("comm:")) {
            throw new URISyntaxException(uri, "Does not start with comm:");
        }
        int idx = uri.indexOf(";") == -1 ? uri.length() : uri.indexOf(";");
        String port = uri.substring(5, idx);
        Builder builder = new Builder(port);
        if (idx != uri.length()) {
            String[] params;
            String[] stringArray = params = uri.substring(idx).split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                int i = param.indexOf("=");
                if (i != -1) {
                    String name = param.substring(0, i);
                    String value = param.substring(i + 1);
                    if ("baudrate".equals(name)) {
                        builder = builder.withBaudRate(Integer.parseInt(value));
                    } else if ("databits".equals(name)) {
                        builder = builder.withDataBits(Integer.parseInt(value));
                    } else if ("stopbits".equals(name)) {
                        builder = builder.withStopBits(Integer.parseInt(value));
                    } else if ("parity".equals(name)) {
                        builder = builder.withParity(Integer.parseInt(value));
                    } else if ("flowcontrol".equals(name)) {
                        builder = builder.withFlowControl(Integer.parseInt(value));
                    } else if ("timeout".equals(name)) {
                        builder = builder.withOpenTimeout(Integer.parseInt(value));
                    } else if ("receivetimeout".equals(name)) {
                        builder = builder.withReceiveTimeout(Integer.parseInt(value));
                    }
                }
                ++n2;
            }
        }
        return builder.build();
    }

    /* synthetic */ CommURI(Builder builder, CommURI commURI) {
        this(builder);
    }

    @ProviderType
    public static class Builder {
        private final String builderPort;
        private int builderBaudRate = 19200;
        private int builderDdataBits = 8;
        private int builderStopBits = 1;
        private int builderParity = 0;
        private int builderFlowControl = 0;
        private int builderOpenTimeout = 2000;
        private int builderReceiveTimeout = 0;

        public Builder(String port) {
            this.builderPort = port;
        }

        public Builder withBaudRate(int baudRate) {
            this.builderBaudRate = baudRate;
            return this;
        }

        public Builder withDataBits(int dataBits) {
            this.builderDdataBits = dataBits;
            return this;
        }

        public Builder withStopBits(int stopBits) {
            this.builderStopBits = stopBits;
            return this;
        }

        public Builder withParity(int parity) {
            this.builderParity = parity;
            return this;
        }

        public Builder withFlowControl(int flowControl) {
            this.builderFlowControl = flowControl;
            return this;
        }

        @Deprecated
        public Builder withTimeout(int timeout) {
            return this.withOpenTimeout(timeout);
        }

        public Builder withOpenTimeout(int timeout) {
            this.builderOpenTimeout = timeout;
            return this;
        }

        public Builder withReceiveTimeout(int timeout) {
            this.builderReceiveTimeout = timeout;
            return this;
        }

        public CommURI build() {
            return new CommURI(this, null);
        }
    }
}

