/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.cloud.MessageHandlerCallable;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;

@Deprecated
@ConsumerType
public abstract class Cloudlet
implements CloudClientListener {
    private static final Logger logger = LogManager.getLogger(Cloudlet.class);
    protected static final int DFLT_PUB_QOS = 0;
    protected static final boolean DFLT_RETAIN = false;
    protected static final int DFLT_PRIORITY = 1;
    private static final int NUM_CONCURRENT_CALLBACKS = 2;
    private static ExecutorService callbackExecutor = Executors.newFixedThreadPool(2);
    private CloudService cloudService;
    private CloudClient cloudClient;
    private ComponentContext ctx;
    private final String applicationId;

    public void setCloudService(CloudService cloudService) {
        this.cloudService = cloudService;
    }

    public void unsetCloudService(CloudService cloudService) {
        this.cloudService = null;
    }

    protected void activate(ComponentContext componentContext) {
        try {
            logger.info("Getting CloudApplicationClient for {}...", (Object)this.applicationId);
            this.cloudClient = this.cloudService.newCloudClient(this.applicationId);
            this.cloudClient.addCloudClientListener(this);
            this.ctx = componentContext;
        }
        catch (KuraException e) {
            logger.error("Cannot activate", (Throwable)e);
            throw new ComponentException((Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Releasing CloudApplicationClient for {}...", (Object)this.applicationId);
        if (this.cloudClient != null) {
            this.cloudClient.release();
        }
    }

    protected Cloudlet(String appId) {
        this.applicationId = appId;
    }

    public String getAppId() {
        return this.applicationId;
    }

    protected CloudService getCloudService() {
        return this.cloudService;
    }

    protected CloudClient getCloudApplicationClient() {
        return this.cloudClient;
    }

    protected ComponentContext getComponentContext() {
        return this.ctx;
    }

    protected void doGet(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        logger.info("Default GET handler");
        respPayload.setResponseCode(404);
    }

    protected void doPut(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        logger.info("Default PUT handler");
        respPayload.setResponseCode(404);
    }

    protected void doPost(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        logger.info("Default POST handler");
        respPayload.setResponseCode(404);
    }

    protected void doDel(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        logger.info("Default DEL handler");
        respPayload.setResponseCode(404);
    }

    protected void doExec(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        logger.info("Default EXEC handler");
        respPayload.setResponseCode(404);
    }

    @Override
    public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        try {
            logger.debug("Control Arrived on topic: {}", (Object)appTopic);
            StringBuilder sb = new StringBuilder(this.applicationId).append("/").append("REPLY");
            if (appTopic.startsWith(sb.toString())) {
                return;
            }
            callbackExecutor.submit(new MessageHandlerCallable(this, deviceId, appTopic, msg, qos, retain));
        }
        catch (Throwable t) {
            logger.error("Unexpected throwable: {}", t);
        }
    }

    @Override
    public void onMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        logger.error("Unexpected message arrived on topic: " + appTopic);
    }

    @Override
    public void onConnectionLost() {
        logger.warn("Cloud Client Connection Lost!");
    }

    @Override
    public void onConnectionEstablished() {
        logger.info("Cloud Client Connection Restored");
    }

    @Override
    public void onMessageConfirmed(int messageId, String topic) {
        logger.debug("Message Confirmed (" + messageId + ")");
    }

    @Override
    public void onMessagePublished(int messageId, String topic) {
        logger.debug("Message Published (" + messageId + ")");
    }
}

