/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.linux.executor;

import java.util.function.Consumer;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.Executor;
import org.eclipse.kura.core.internal.linux.executor.ExecutorUtil;
import org.eclipse.kura.core.linux.executor.LinuxExitStatus;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.executor.ExitStatus;

public class LinuxResultHandler
implements ExecuteResultHandler {
    private static final int TIMEOUT_EXIT_VALUE = 124;
    private static final int SIGTERM_EXIT_VALUE = 143;
    private final Consumer<CommandStatus> callback;
    private CommandStatus commandStatus;
    private Executor executor;

    public LinuxResultHandler(Consumer<CommandStatus> callback, Executor executor) {
        this.callback = callback;
        this.executor = executor;
    }

    public CommandStatus getStatus() {
        return this.commandStatus;
    }

    public void setStatus(CommandStatus status) {
        this.commandStatus = status;
    }

    public void onProcessComplete(int exitValue) {
        ExecutorUtil.stopStreamHandler(this.executor);
        this.commandStatus.setExitStatus((ExitStatus)new LinuxExitStatus(exitValue));
        this.callback.accept(this.commandStatus);
    }

    public void onProcessFailed(ExecuteException e) {
        ExecutorUtil.stopStreamHandler(this.executor);
        this.commandStatus.setExitStatus((ExitStatus)new LinuxExitStatus(e.getExitValue()));
        if (e.getExitValue() == 124 || e.getExitValue() == 143) {
            this.commandStatus.setTimedout(true);
        }
        this.callback.accept(this.commandStatus);
    }
}

