/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import com.github.hypfvieh.bluetooth.DeviceManager;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeService;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.internal.ble.BluetoothLeAdapterImpl;
import org.freedesktop.dbus.exceptions.DBusException;
import org.osgi.service.component.ComponentContext;

public class BluetoothLeServiceImpl
implements BluetoothLeService {
    private static final Logger logger = LogManager.getLogger(BluetoothLeServiceImpl.class);
    private DeviceManager deviceManager;
    private CommandExecutorService executorService;

    public void setExecutorService(CommandExecutorService executorService) {
        this.executorService = executorService;
    }

    public void unsetExecutorService(CommandExecutorService executorService) {
        if (this.executorService == executorService) {
            this.executorService = null;
        }
    }

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le Service...");
        if (!(this.startBluetoothUbuntuSnap() || this.startBluetoothSystemd() || this.startBluetoothInitd())) {
            this.startBluetoothDaemon();
        }
        try {
            this.deviceManager = this.getDeviceManager();
        }
        catch (DBusException e) {
            logger.error("Failed to start bluetooth service", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Service...");
        if (this.deviceManager != null) {
            this.deviceManager.closeConnection();
            this.deviceManager = null;
        }
    }

    public List<BluetoothLeAdapter> getAdapters() {
        ArrayList<BluetoothLeAdapter> adapters = new ArrayList<BluetoothLeAdapter>();
        if (this.deviceManager != null) {
            for (BluetoothAdapter adapter : this.deviceManager.getAdapters()) {
                adapters.add(new BluetoothLeAdapterImpl(adapter));
            }
        }
        return adapters;
    }

    public BluetoothLeAdapter getAdapter(String interfaceName) {
        BluetoothAdapter ba;
        BluetoothLeAdapterImpl adapter = null;
        if (this.deviceManager != null && (ba = this.deviceManager.getAdapter(interfaceName)) != null) {
            adapter = new BluetoothLeAdapterImpl(ba);
        }
        return adapter;
    }

    private boolean startBluetoothSystemd() {
        return this.execute("systemctl start bluetooth");
    }

    private boolean startBluetoothInitd() {
        return this.execute("/etc/init.d/bluetooth start");
    }

    private void startBluetoothDaemon() {
        this.execute("bluetoothd -E");
    }

    private boolean startBluetoothUbuntuSnap() {
        String snapName = System.getProperty("kura.os.snap.name");
        if (snapName != null && snapName.length() != 0) {
            logger.info("We are running as snap, assume bluetooth is running");
            return true;
        }
        return false;
    }

    private boolean execute(String commandLine) {
        Command command = new Command(commandLine.split(" "));
        boolean started = this.executorService.execute(command).getExitStatus().isSuccessful();
        if (!started) {
            logger.error("Failed to start linux bluetooth service");
        }
        return started;
    }

    public DeviceManager getDeviceManager() throws DBusException {
        return DeviceManager.createInstance((boolean)false);
    }
}

