/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.BundleContext;
import org.tigris.mtoolkit.iagent.internal.utils.log.ConsoleLog;
import org.tigris.mtoolkit.iagent.internal.utils.log.EclipseLog;
import org.tigris.mtoolkit.iagent.internal.utils.log.FileLog;
import org.tigris.mtoolkit.iagent.internal.utils.log.Log;
import org.tigris.mtoolkit.iagent.internal.utils.log.OSGiLog;

public class DebugUtils {
    private static final String PROP_DEBUG_ENABLED = "iagent.debug";
    private static final String PROP_LOG_FILE = "iagent.log.file";
    private static final String NL = System.getProperty("line.separator");
    public static final boolean DEBUG_ENABLED = Boolean.getBoolean("iagent.debug");
    private static Log log;
    private static boolean initialized;

    static {
        initialized = false;
    }

    public static final void info(Object module, String message) {
        DebugUtils.log(module, 0, message);
    }

    public static final void info(Object module, String message, Throwable t) {
        DebugUtils.log(module, 0, message, t);
    }

    public static final void debug(Object module, String message) {
        DebugUtils.log(module, 2, message);
    }

    public static final void debug(Object module, String message, Throwable t) {
        DebugUtils.log(module, 2, message, t);
    }

    public static final void error(Object module, String message) {
        DebugUtils.log(module, 1, message);
    }

    public static final void error(Object module, String message, Throwable t) {
        DebugUtils.log(module, 1, message, t);
    }

    public static void initialize(BundleContext context) {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            String logFileName = System.getProperty(PROP_LOG_FILE);
            if (logFileName != null) {
                log = new FileLog(new File(logFileName));
                return;
            }
        }
        catch (Throwable throwable) {}
        try {
            log = new EclipseLog(context);
            return;
        }
        catch (Throwable throwable) {
            try {
                log = new OSGiLog(context);
                return;
            }
            catch (Throwable throwable2) {
                try {
                    log = new ConsoleLog();
                    return;
                }
                catch (Throwable throwable3) {
                    log = null;
                    return;
                }
            }
        }
    }

    public static final void log(Object module, int severity, String message) {
        DebugUtils.log(module, severity, message, null);
    }

    public static final void log(Object module, int severity, String message, Throwable t) {
        if (severity == 2 && !DEBUG_ENABLED) {
            return;
        }
        if (!initialized) {
            DebugUtils.initialize(null);
        }
        String logMessage = "[IAgent][" + DebugUtils.getIdentityString(module) + "] " + message;
        if (log != null) {
            log.log(severity, logMessage, t);
        }
    }

    public static String convertForDebug(long[] arr) {
        if (!DEBUG_ENABLED) {
            return "(debug disabled)";
        }
        if (arr == null) {
            return "null";
        }
        if (arr.length == 0) {
            return "(none)";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(arr[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static String convertForDebug(Object[] arr) {
        if (!DEBUG_ENABLED) {
            return "(debug disabled)";
        }
        if (arr == null) {
            return "[null]";
        }
        if (arr.length == 0) {
            return "[(none)]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        int i = 0;
        while (i < arr.length) {
            Object element;
            if (i > 0) {
                buf.append(',');
            }
            String elementStr = (element = arr[i]) instanceof Dictionary ? DebugUtils.convertForDebug((Dictionary)element) : (element != null && element.getClass().isArray() && !element.getClass().getComponentType().isPrimitive() ? DebugUtils.convertForDebug((Object[])element) : (element != null ? element.toString() : "null"));
            buf.append(elementStr);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static String flattenStringArray(String[] arr) {
        if (arr == null) {
            return "[null]";
        }
        if (arr.length == 0) {
            return "[(none)]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(arr[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static String convertForDebug(Dictionary dict) {
        if (!DEBUG_ENABLED) {
            return "(debug disabled)";
        }
        if (dict == null) {
            return "{null}";
        }
        if (dict.size() == 0) {
            return "{(none)}";
        }
        Enumeration e = dict.keys();
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (buf.length() > 1) {
                buf.append(',');
            }
            buf.append(key);
            buf.append('=');
            Object value = dict.get(key);
            String valueStr = value instanceof Dictionary ? DebugUtils.convertForDebug((Dictionary)value) : (value != null && value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive() ? DebugUtils.convertForDebug((Object[])value) : (value != null ? value.toString() : "null"));
            buf.append(valueStr);
        }
        buf.append('}');
        return buf.toString();
    }

    private static String getIdentityString(Object obj) {
        if (obj == null) {
            return "(null)";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Class) {
            return DebugUtils.getClassName(((Class)obj).getName());
        }
        Class<?> cl = obj.getClass();
        return String.valueOf(DebugUtils.getClassName(cl.getName())) + '@' + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getClassName(String fullClassName) {
        int idx = fullClassName.lastIndexOf(46);
        if (idx != -1) {
            return fullClassName.substring(idx + 1, fullClassName.length());
        }
        return fullClassName;
    }

    public static String toString(Exception e) {
        StringBuffer err = new StringBuffer();
        err.append(e.toString());
        try {
            Object ex;
            Method cause = e.getClass().getMethod("getCause", new Class[0]);
            if (cause != null && (ex = cause.invoke((Object)e, new Object[0])) != null) {
                err.append(NL).append("Caused by: ").append(ex.toString());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return err.toString();
    }

    public static String getStackTrace(Throwable e) {
        StringBuffer err = new StringBuffer();
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        err.append(sw.toString());
        try {
            Object ex;
            Method cause = e.getClass().getMethod("getCause", new Class[0]);
            if (cause != null && (ex = cause.invoke((Object)e, new Object[0])) instanceof Throwable) {
                err.append(NL).append(DebugUtils.getStackTrace((Throwable)ex));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return err.toString();
    }
}

