/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.web.AuthenticationManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtSettings;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSettingService;

public class GwtSettingServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSettingService {
    private static final long serialVersionUID = -3422518194598042896L;

    @Override
    public void updateSettings(GwtXSRFToken xsrfToken, GwtSettings settings) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        AuthenticationManager authMgr = AuthenticationManager.getInstance();
        boolean validCurrPwd = false;
        validCurrPwd = authMgr.authenticate("admin", settings.getPasswordCurrent());
        if (!validCurrPwd) {
            throw new GwtKuraException(GwtKuraErrorCode.CURRENT_ADMIN_PASSWORD_DOES_NOT_MATCH);
        }
    }

    @Override
    public void logout(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        Enumeration attrs = httpSession.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            httpSession.removeAttribute(attr);
        }
        httpSession.setAttribute("logout", (Object)"true");
    }
}

