/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.web.AuthenticationManager;
import org.eclipse.kura.web.Console;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureBasicHttpContext
implements HttpContext {
    private static Logger s_logger = LoggerFactory.getLogger(SecureBasicHttpContext.class);
    private final HttpContext delegate;
    private final AuthenticationManager m_authMgr;
    private final String m_appRoot;

    public SecureBasicHttpContext(HttpContext delegate, AuthenticationManager authMgr) {
        this.delegate = delegate;
        this.m_authMgr = authMgr;
        this.m_appRoot = Console.getApplicationRoot();
    }

    public String getMimeType(String name) {
        return this.delegate.getMimeType(name);
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public synchronized boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String password;
        int colon;
        String logout;
        HttpSession session;
        response.setHeader("X-FRAME-OPTIONS", "SAMEORIGIN");
        response.setHeader("X-XSS-protection", "1; mode=block");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Cache-Control", "no-cache,no-store");
        response.setHeader("Pragma", "no-cache");
        if (request.getRequestURI().equals(String.valueOf(this.m_appRoot) + "/")) {
            response.sendRedirect(this.m_appRoot);
        }
        if (request.getRequestURI().equals("/")) {
            response.sendRedirect(this.m_appRoot);
        }
        if ((session = request.getSession(false)) != null && (logout = (String)session.getAttribute("logout")) != null) {
            session.removeAttribute("logout");
            session.invalidate();
            return this.failAuthorization(response);
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            s_logger.debug("Missing 'Authorization' HTTP header");
            return this.failAuthorization(response);
        }
        StringTokenizer tokens = new StringTokenizer(authHeader);
        String authScheme = tokens.nextToken();
        if (!"Basic".equals(authScheme)) {
            s_logger.error("The authentication scheme is not 'Basic'");
            return this.failAuthorization(response);
        }
        String credentials = new String(Base64.getDecoder().decode(tokens.nextToken()), StandardCharsets.UTF_8);
        String userid = credentials.substring(0, colon = credentials.indexOf(58));
        Subject subject = this.login(request, response, userid, password = credentials.substring(colon + 1));
        if (subject == null) {
            return this.failAuthorization(response);
        }
        request.setAttribute("org.osgi.service.http.authentication.remote.user", null);
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)request.getAuthType());
        request.setAttribute("org.osgi.service.useradmin.authorization", null);
        return true;
    }

    private boolean failAuthorization(HttpServletResponse response) {
        response.setHeader("WWW-Authenticate", "Basic realm=\"Secure Area\"");
        response.setStatus(401);
        return false;
    }

    private Subject login(HttpServletRequest request, HttpServletResponse response, String userid, String password) {
        Subject subject = null;
        HttpSession session = request.getSession(true);
        subject = this.authorize(userid, password);
        session.setAttribute("subject", (Object)subject);
        session.setAttribute("username", (Object)userid);
        if (session.isNew()) {
            String sessionid = session.getId();
            response.setHeader("SET-COOKIE", "JSESSIONID=" + sessionid + "; HttpOnly");
        }
        return subject;
    }

    private Subject authorize(String userid, String password) {
        s_logger.debug("Authenticating user [{}]", (Object)userid);
        try {
            if (this.m_authMgr.authenticate(userid, password)) {
                return new Subject();
            }
        }
        catch (Exception e) {
            s_logger.error("Error during authentication", (Throwable)e);
        }
        return null;
    }
}

