/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.AuthenticationManager;
import org.eclipse.kura.web.SecureBasicHttpContext;
import org.eclipse.kura.web.server.GwtAssetServiceImpl;
import org.eclipse.kura.web.server.GwtCertificatesServiceImpl;
import org.eclipse.kura.web.server.GwtCloudConnectionServiceImpl;
import org.eclipse.kura.web.server.GwtComponentServiceImpl;
import org.eclipse.kura.web.server.GwtDeviceServiceImpl;
import org.eclipse.kura.web.server.GwtEventServiceImpl;
import org.eclipse.kura.web.server.GwtNetworkServiceImpl;
import org.eclipse.kura.web.server.GwtPackageServiceImpl;
import org.eclipse.kura.web.server.GwtSecurityServiceImpl;
import org.eclipse.kura.web.server.GwtSecurityTokenServiceImpl;
import org.eclipse.kura.web.server.GwtSettingServiceImpl;
import org.eclipse.kura.web.server.GwtSnapshotServiceImpl;
import org.eclipse.kura.web.server.GwtSslServiceImpl;
import org.eclipse.kura.web.server.GwtStatusServiceImpl;
import org.eclipse.kura.web.server.GwtWireGraphServiceImpl;
import org.eclipse.kura.web.server.servlet.ChannelServlet;
import org.eclipse.kura.web.server.servlet.DeviceSnapshotsServlet;
import org.eclipse.kura.web.server.servlet.FileServlet;
import org.eclipse.kura.web.server.servlet.SkinServlet;
import org.eclipse.kura.web.server.servlet.WiresBlinkServlet;
import org.eclipse.kura.web.server.servlet.WiresSnapshotServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements ConfigurableComponent {
    private static final Logger s_logger = LoggerFactory.getLogger(Console.class);
    private static final String SERVLET_ALIAS_ROOT = "servlet.alias.root";
    private static final String APP_ROOT = "app.root";
    private static final String CONSOLE_PASSWORD = "console.password.value";
    private static final String CONSOLE_USERNAME = "console.username.value";
    private static String s_aliasRoot;
    private static String s_appRoot;
    private static ComponentContext s_context;
    private HttpService m_httpService;
    private SystemService m_systemService;
    private CryptoService m_cryptoService;
    private Map<String, Object> m_properties;
    private EventAdmin m_eventAdmin;
    private AuthenticationManager authMgr;
    private GwtEventServiceImpl eventService;

    public void setHttpService(HttpService httpService) {
        this.m_httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.m_httpService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.m_cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.m_cryptoService = null;
    }

    public void setEventAdminService(EventAdmin eventAdmin) {
        this.m_eventAdmin = eventAdmin;
    }

    public void unsetEventAdminService(EventAdmin eventAdmin) {
        this.m_eventAdmin = null;
    }

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        block8: {
            try {
                boolean webEnabled = Boolean.parseBoolean(this.m_systemService.getKuraWebEnabled());
                if (webEnabled) {
                    s_logger.info("activate...");
                    s_context = context;
                    s_aliasRoot = (String)properties.get(SERVLET_ALIAS_ROOT);
                    s_appRoot = (String)properties.get(APP_ROOT);
                    String servletRoot = s_aliasRoot;
                    this.m_properties = new HashMap<String, Object>();
                    for (String key : properties.keySet()) {
                        Object value = properties.get(key);
                        this.m_properties.put(key, value);
                    }
                    Object pwdProp = properties.get(CONSOLE_PASSWORD);
                    char[] propertyPassword = null;
                    propertyPassword = pwdProp instanceof char[] ? (char[])properties.get(CONSOLE_PASSWORD) : properties.get(CONSOLE_PASSWORD).toString().toCharArray();
                    try {
                        propertyPassword = this.m_cryptoService.decryptAes(propertyPassword);
                    }
                    catch (Exception exception) {}
                    Object value = properties.get(CONSOLE_PASSWORD);
                    char[] decryptedPassword = null;
                    try {
                        decryptedPassword = this.m_cryptoService.decryptAes(((String)value).toCharArray());
                    }
                    catch (Exception exception) {
                        decryptedPassword = value.toString().toCharArray();
                    }
                    propertyPassword = this.m_cryptoService.sha1Hash(new String(decryptedPassword)).toCharArray();
                    String registeredUsername = (String)properties.get(CONSOLE_USERNAME);
                    this.authMgr = new AuthenticationManager(registeredUsername, propertyPassword);
                    this.eventService = new GwtEventServiceImpl();
                    this.initHTTPService(this.authMgr, servletRoot);
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("kura.version", this.m_systemService.getKuraVersion());
                    EventProperties eventProps = new EventProperties(props);
                    s_logger.info("postInstalledEvent() :: posting KuraConfigReadyEvent");
                    this.m_eventAdmin.postEvent(new Event("org/eclipse/kura/configuration/ConfigEvent/READY", (Map)eventProps));
                    break block8;
                }
                s_logger.info("Web interface disabled in Kura properties file.");
            }
            catch (Throwable t) {
                s_logger.warn("Error Registering Web Resources", t);
            }
        }
    }

    protected void updated(Map<String, Object> properties) {
        boolean webEnabled = Boolean.parseBoolean(this.m_systemService.getKuraWebEnabled());
        if (!webEnabled) {
            return;
        }
        char[] propertyPassword = null;
        String registeredUsername = (String)properties.get(CONSOLE_USERNAME);
        this.authMgr.updateUsername(registeredUsername);
        try {
            Object value = properties.get(CONSOLE_PASSWORD);
            char[] decryptedPassword = null;
            try {
                decryptedPassword = this.m_cryptoService.decryptAes(((String)value).toCharArray());
            }
            catch (Exception exception) {
                decryptedPassword = value.toString().toCharArray();
            }
            propertyPassword = this.m_cryptoService.sha1Hash(new String(decryptedPassword)).toCharArray();
            this.authMgr.updatePassword(propertyPassword);
        }
        catch (Exception e) {
            s_logger.warn("Error Updating Web properties", (Throwable)e);
        }
    }

    protected void deactivate(BundleContext context) {
        s_logger.info("deactivate...");
        s_context = null;
        this.unregisterServlet();
    }

    private void unregisterServlet() {
        String servletRoot = s_aliasRoot;
        this.m_httpService.unregister("/");
        this.m_httpService.unregister(s_appRoot);
        this.m_httpService.unregister(s_aliasRoot);
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/status");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/device");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/network");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/component");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/package");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/snapshot");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/setting");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/file");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/device_snapshots");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/assetsUpDownload");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/skin");
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/wires");
        this.m_httpService.unregister("/sse");
        this.eventService.stop();
        this.m_httpService.unregister(String.valueOf(servletRoot) + "/event");
    }

    public static BundleContext getBundleContext() {
        return s_context.getBundleContext();
    }

    public static String getApplicationRoot() {
        return s_appRoot;
    }

    public static String getServletRoot() {
        return s_aliasRoot;
    }

    private void initHTTPService(AuthenticationManager authMgr, String servletRoot) throws NamespaceException, ServletException {
        SecureBasicHttpContext httpCtx = new SecureBasicHttpContext(this.m_httpService.createDefaultHttpContext(), authMgr);
        this.m_httpService.registerResources("/", "www", (HttpContext)httpCtx);
        this.m_httpService.registerResources(s_appRoot, "www/denali.html", (HttpContext)httpCtx);
        this.m_httpService.registerResources(s_aliasRoot, "www" + s_aliasRoot, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/xsrf", (Servlet)new GwtSecurityTokenServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/status", (Servlet)new GwtStatusServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/device", (Servlet)new GwtDeviceServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/network", (Servlet)new GwtNetworkServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/component", (Servlet)new GwtComponentServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/package", (Servlet)new GwtPackageServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/snapshot", (Servlet)new GwtSnapshotServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/setting", (Servlet)new GwtSettingServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/certificate", (Servlet)new GwtCertificatesServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/security", (Servlet)new GwtSecurityServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/file", (Servlet)new FileServlet(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/device_snapshots", (Servlet)new DeviceSnapshotsServlet(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/assetsUpDownload", (Servlet)new ChannelServlet(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/skin", (Servlet)new SkinServlet(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/ssl", (Servlet)new GwtSslServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/cloudservices", (Servlet)new GwtCloudConnectionServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/wires", (Servlet)new GwtWireGraphServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/wiresSnapshot", (Servlet)new WiresSnapshotServlet(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/assetservices", (Servlet)new GwtAssetServiceImpl(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet("/sse", (Servlet)new WiresBlinkServlet(), null, (HttpContext)httpCtx);
        this.m_httpService.registerServlet(String.valueOf(servletRoot) + "/event", (Servlet)this.eventService, null, (HttpContext)httpCtx);
        this.eventService.start();
    }
}

