/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.publisher;

import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.internal.wire.publisher.PositionType;

final class CloudPublisherOptions {
    private static final Logger logger = LogManager.getLogger();
    private static final String CONF_POSITION = "publish.position";
    private final Map<String, Object> properties;

    CloudPublisherOptions(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Properties cannot be null");
        this.properties = properties;
    }

    PositionType getPositionType() {
        String positionTypeString = "";
        Object configurationPositionType = this.properties.get(CONF_POSITION);
        if (Objects.nonNull(configurationPositionType) && configurationPositionType instanceof String) {
            positionTypeString = (String)configurationPositionType;
        }
        PositionType result = PositionType.NONE;
        try {
            result = PositionType.getEncoding(positionTypeString);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Cannot parse the provided position type.", (Throwable)e);
        }
        return result;
    }
}

