/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.comm;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.StringJoiner;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.comm.CommConnection;
import org.eclipse.kura.comm.CommURI;

public class CommConnectionImpl
implements CommConnection,
Closeable {
    private static final String SEND_MESSAGE = "sendMessage() - {}";
    private static final String JAVA_EXT_DIRS = "java.ext.dirs";
    private static final String KURA_EXT_DIR = "kura.ext.dir";
    private static final Logger logger = LogManager.getLogger(CommConnectionImpl.class);
    private final CommURI commUri;
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream outputStream;

    static {
        String kuraExtDir = System.getProperty(KURA_EXT_DIR);
        if (kuraExtDir != null) {
            StringBuffer sb = new StringBuffer();
            String existingDirs = System.getProperty(JAVA_EXT_DIRS);
            if (existingDirs != null) {
                if (!existingDirs.contains(kuraExtDir)) {
                    sb.append(existingDirs).append(File.pathSeparator).append(kuraExtDir);
                    System.setProperty(JAVA_EXT_DIRS, sb.toString());
                }
            } else {
                sb.append(kuraExtDir);
                System.setProperty(JAVA_EXT_DIRS, sb.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommConnectionImpl(CommURI commUri, int mode, boolean timeouts) throws IOException, NoSuchPortException, PortInUseException {
        Objects.requireNonNull(commUri);
        this.commUri = commUri;
        String port = this.commUri.getPort();
        int baudRate = this.commUri.getBaudRate();
        int dataBits = this.commUri.getDataBits();
        int stopBits = this.commUri.getStopBits();
        int parity = this.commUri.getParity();
        int flowControl = this.commUri.getFlowControl();
        int openTimeout = this.commUri.getOpenTimeout();
        int receiveTimeout = this.commUri.getReceiveTimeout();
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)port);
        CommPort commPort = commPortIdentifier.open(this.getClass().getName(), openTimeout);
        if (!(commPort instanceof SerialPort)) throw new IOException("Unsupported Port Type");
        this.serialPort = (SerialPort)commPort;
        try {
            this.serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
            this.serialPort.setFlowControlMode(flowControl);
            if (receiveTimeout <= 0) return;
            this.serialPort.enableReceiveTimeout(receiveTimeout);
            if (this.serialPort.isReceiveTimeoutEnabled()) return;
            throw new IOException("Serial receive timeout not supported by driver");
        }
        catch (UnsupportedCommOperationException e) {
            logger.error("Failed to configure COM port", (Throwable)e);
            throw new IOException(e);
        }
    }

    public CommURI getURI() {
        return this.commUri;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public synchronized InputStream openInputStream() throws IOException {
        this.checkIfClosed();
        if (this.inputStream == null) {
            this.inputStream = this.serialPort.getInputStream();
        }
        return this.inputStream;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        this.checkIfClosed();
        if (this.outputStream == null) {
            this.outputStream = this.serialPort.getOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.serialPort != null) {
            this.serialPort.notifyOnDataAvailable(false);
            this.serialPort.removeEventListener();
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.serialPort == null) {
            throw new IOException("Connection is already closed");
        }
    }

    public synchronized void sendMessage(byte[] message) throws KuraException, IOException {
        this.checkIfClosed();
        if (message == null) {
            throw new NullPointerException("Message must not be null");
        }
        logger.debug(SEND_MESSAGE, new Supplier[]{() -> CommConnectionImpl.getBytesAsString(message)});
        if (this.outputStream == null) {
            this.openOutputStream();
        }
        this.outputStream.write(message, 0, message.length);
        this.outputStream.flush();
    }

    public synchronized byte[] sendCommand(byte[] command, int timeout) throws KuraException, IOException {
        byte[] dataInBuffer;
        this.checkIfClosed();
        if (command == null) {
            throw new NullPointerException("Serial command must not be null");
        }
        logger.debug(SEND_MESSAGE, new Supplier[]{() -> CommConnectionImpl.getBytesAsString(command)});
        if (this.outputStream == null) {
            this.openOutputStream();
        }
        if (this.inputStream == null) {
            this.openInputStream();
        }
        if ((dataInBuffer = this.flushSerialBuffer()) != null && dataInBuffer.length > 0) {
            logger.warn("eating bytes in the serial buffer input stream before sending command: {}", (Object)CommConnectionImpl.getBytesAsString(dataInBuffer));
        }
        this.outputStream.write(command, 0, command.length);
        this.outputStream.flush();
        ByteBuffer buffer = this.getResponse(timeout);
        if (buffer != null) {
            byte[] response = new byte[buffer.limit()];
            buffer.get(response, 0, response.length);
            return response;
        }
        return null;
    }

    public synchronized byte[] sendCommand(byte[] command, int timeout, int demark) throws KuraException, IOException {
        byte[] dataInBuffer;
        this.checkIfClosed();
        if (command == null) {
            throw new NullPointerException("Serial command must not be null");
        }
        logger.debug(SEND_MESSAGE, (Object)CommConnectionImpl.getBytesAsString(command));
        if (this.outputStream == null) {
            this.openOutputStream();
        }
        if (this.inputStream == null) {
            this.openInputStream();
        }
        if ((dataInBuffer = this.flushSerialBuffer()) != null && dataInBuffer.length > 0) {
            logger.warn("eating bytes in the serial buffer input stream before sending command: {}", (Object)CommConnectionImpl.getBytesAsString(dataInBuffer));
        }
        this.outputStream.write(command, 0, command.length);
        this.outputStream.flush();
        ByteBuffer buffer = this.getResponse(timeout, demark);
        if (buffer != null) {
            byte[] response = new byte[buffer.limit()];
            buffer.get(response, 0, response.length);
            return response;
        }
        return null;
    }

    public synchronized byte[] flushSerialBuffer() throws KuraException, IOException {
        this.checkIfClosed();
        ByteBuffer buffer = this.getResponse(50);
        if (buffer != null) {
            byte[] response = new byte[buffer.limit()];
            buffer.get(response, 0, response.length);
            return response;
        }
        return null;
    }

    private synchronized ByteBuffer getResponse(int timeout) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        long start = System.currentTimeMillis();
        while (this.inputStream.available() < 1 && System.currentTimeMillis() - start < (long)timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        while (this.inputStream.available() >= 1) {
            int c = this.inputStream.read();
            buffer.put((byte)c);
        }
        buffer.flip();
        return buffer.limit() > 0 ? buffer : null;
    }

    private synchronized ByteBuffer getResponse(int timeout, int demark) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        long start = System.currentTimeMillis();
        while (this.inputStream.available() < 1 && System.currentTimeMillis() - start < (long)timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        start = System.currentTimeMillis();
        do {
            if (this.inputStream.available() <= 0) continue;
            start = System.currentTimeMillis();
            int c = this.inputStream.read();
            buffer.put((byte)c);
        } while (System.currentTimeMillis() - start < (long)demark);
        buffer.flip();
        return buffer.limit() > 0 ? buffer : null;
    }

    static String getBytesAsString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringJoiner sj = new StringJoiner(" ");
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sj.add(String.format("%02X", b));
            ++n2;
        }
        return sj.toString();
    }
}

