/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;

public abstract class Command {
    private final List m_rollback = new ArrayList();
    private final List m_commit = new ArrayList();
    private volatile boolean m_cancelled;

    public abstract void execute(DeploymentSessionImpl var1) throws DeploymentException;

    protected void rollback(DeploymentSessionImpl session) {
        ListIterator i = this.m_rollback.listIterator(this.m_rollback.size());
        while (i.hasPrevious()) {
            Runnable runnable = (Runnable)i.previous();
            runnable.run();
        }
        this.cleanUp();
    }

    protected void commit(DeploymentSessionImpl session) {
        ListIterator i = this.m_commit.listIterator();
        while (i.hasNext()) {
            Runnable runnable = (Runnable)i.next();
            runnable.run();
        }
        this.cleanUp();
    }

    private void cleanUp() {
        this.m_rollback.clear();
        this.m_commit.clear();
        this.m_cancelled = false;
    }

    protected boolean isCancelled() {
        return this.m_cancelled;
    }

    protected void addRollback(Runnable runnable) {
        this.m_rollback.add(runnable);
    }

    protected void addCommit(Runnable runnable) {
        this.m_commit.add(runnable);
    }

    public void cancel() {
        this.m_cancelled = true;
    }

    static final boolean isFragmentBundle(Bundle bundle) {
        Object fragmentHost = bundle.getHeaders().get("Fragment-Host");
        return fragmentHost != null;
    }
}

