/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxEncoder;
import io.moquette.parser.netty.Utils;
import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.SubAckMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

class SubAckEncoder
extends DemuxEncoder<SubAckMessage> {
    SubAckEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext chc, SubAckMessage message, ByteBuf out) {
        if (message.types().isEmpty()) {
            throw new IllegalArgumentException("Found a suback message with empty topics");
        }
        int variableHeaderSize = 2 + message.types().size();
        ByteBuf buff = chc.alloc().buffer(6 + variableHeaderSize);
        try {
            buff.writeByte(144);
            buff.writeBytes(Utils.encodeRemainingLength(variableHeaderSize));
            buff.writeShort(message.getMessageID());
            for (AbstractMessage.QOSType c : message.types()) {
                buff.writeByte(c.byteValue());
            }
            out.writeBytes(buff);
        }
        finally {
            buff.release();
        }
    }
}

