/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.ibeacon;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.kura.ble.ibeacon.BluetoothLeIBeacon;
import org.eclipse.kura.ble.ibeacon.BluetoothLeIBeaconEncoder;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeIBeaconEncoderImpl
implements BluetoothLeIBeaconEncoder {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeIBeaconEncoderImpl.class);
    private static final byte PKT_BYTES_NUMBER = 30;
    private static final byte PAYLOAD_BYTES_NUMBER = 26;
    private static final byte MANUFACTURER_AD = -1;
    private static final byte[] BEACON_ID = new byte[]{2, 21};
    private static final byte[] COMPANY_CODE;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = 76;
        COMPANY_CODE = byArray;
    }

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le IBeacon Codec...");
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Le IBeacon Codec...");
    }

    public Class<BluetoothLeIBeacon> getBeaconType() {
        return BluetoothLeIBeacon.class;
    }

    public byte[] encode(BluetoothLeIBeacon beacon) {
        byte[] data = new byte[32];
        byte flags = this.encodeFlags(beacon);
        data[0] = 30;
        data[1] = 2;
        data[2] = 1;
        data[3] = flags;
        data[4] = 26;
        data[5] = -1;
        data[6] = COMPANY_CODE[1];
        data[7] = COMPANY_CODE[0];
        data[8] = BEACON_ID[0];
        data[9] = BEACON_ID[1];
        System.arraycopy(BluetoothLeIBeaconEncoderImpl.getBytesFromUUID(beacon.getUuid()), 0, data, 10, 16);
        data[26] = (byte)(beacon.getMajor() >> 8 & 0xFF);
        data[27] = (byte)(beacon.getMajor() & 0xFF);
        data[28] = (byte)(beacon.getMinor() >> 8 & 0xFF);
        data[29] = (byte)(beacon.getMinor() & 0xFF);
        data[30] = (byte)(beacon.getTxPower() & 0xFF);
        data[31] = 0;
        return data;
    }

    private byte encodeFlags(BluetoothLeIBeacon beacon) {
        byte flags = 0;
        flags = (byte)(flags | (beacon.isLeLimited() ? 1 : 0));
        flags = (byte)(flags | (beacon.isLeGeneral() ? 2 : 0));
        flags = (byte)(flags | (beacon.isBrEdrSupported() ? 4 : 0));
        flags = (byte)(flags | (beacon.isLeBrController() ? 8 : 0));
        flags = (byte)(flags | (beacon.isLeBrHost() ? 16 : 0));
        return flags;
    }

    private static byte[] getBytesFromUUID(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }
}

