/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnZip {
    private static final String INPUT_ZIP_FILE = "/tmp/test.zip";
    private static final String OUTPUT_FOLDER = "/tmp/";

    public static void main(String[] args) {
        byte[] zipBytes = null;
        try {
            zipBytes = UnZip.getFileBytes(new File(INPUT_ZIP_FILE));
            UnZip.unZipBytes(zipBytes, OUTPUT_FOLDER);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            UnZip.unZipFile(INPUT_ZIP_FILE, OUTPUT_FOLDER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void unZipBytes(byte[] bytes, String outputFolder) throws IOException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));
        UnZip.unZipZipInputStream(zis, outputFolder);
    }

    public static void unZipFile(String filename, String outputFolder) throws IOException {
        File file = new File(filename);
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        UnZip.unZipZipInputStream(zis, outputFolder);
    }

    private static void unZipZipInputStream(ZipInputStream zis, String outFolder) throws IOException {
        File folder;
        String outputFolder = outFolder;
        if (outputFolder == null) {
            outputFolder = System.getProperty("user.dir");
        }
        if (!(folder = new File(outputFolder)).exists()) {
            folder.mkdirs();
        }
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int len;
            byte[] buffer = new byte[1024];
            String fileName = ze.getName();
            File newFile = new File(String.valueOf(outputFolder) + File.separator + fileName);
            if (newFile.isDirectory()) {
                newFile.mkdirs();
                ze = zis.getNextEntry();
                continue;
            }
            if (newFile.getParent() != null) {
                File parent = new File(newFile.getParent());
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static byte[] getFileBytes(File file) throws IOException {
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            try {
                if (ous != null) {
                    ous.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (ous != null) {
                ous.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (ios != null) {
                ios.close();
            }
        }
        catch (IOException iOException) {}
        return ous.toByteArray();
    }
}

